/* Este programa corre un control PID donde los parametros se ingresan con un teclado 4x4
*/

#include "mbed.h"
#include "keypad.h"
#include "TextLCD.h"
#include "stdlib.h"

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
AnalogIn y(PTB0);
AnalogOut u(PTE30);
int C1=0x0F; // Cursor
int C4=0x0C; // quito cursor bajo
int spnum=0,kinum=0,kpnum=0,kdnum=0,pos=1,tecla,flag1=1,num=0;
float med, err, pid, ap, ad, ai, yr, err_v;
float pidn;
int flagt=0;
Timer t;
char cadena[3]={' ',' ',' '};
int llena=0; //verificar que la entrada es de 3 numeros
// Define your own keypad values
char Keytable[] = { '1', '2', '3', 'A',
                    '4', '5', '6', 'B',
                    '7', '8', '9', 'C',
                    '*', '0', '#', 'D'
                  };

uint32_t cbAfterInput(uint32_t index) {
    tecla=index;
    flag1=0;
    return 0;
}

int main() {
    //             f0    f1    f2    f3   c0     c1    c2    c3
    Keypad keypad(PTA2, PTD4, PTD3, PTD7,PTA13, PTD5, PTD0, PTD2);
    ini1:
    err=0; med=0; yr=0; pid=0; ap=0; ai=0; ad=0; err_v=0;pidn=0;
    lcd.cls(); // Borrar Pantalla
    lcd.locate(0,0);
    lcd.printf("**PID-TECLADO**");
    wait(1);
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD

    lcd.locate(8,0);
    lcd.printf("Kp=%d",kpnum);
    lcd.locate(0,1);
    lcd.printf("Ki=%d",kinum);
    lcd.locate(8,1);
    lcd.printf("Kd=%d",kdnum);
    lcd.locate(0,0);
    lcd.printf("Sp=%d",spnum);
    
    ini2:
    keypad.CallAfterInput(&cbAfterInput);
    keypad.Start();
    if(flag1==0){
        if(Keytable[tecla]=='B'){
            cadena[0]=' ';cadena[1]=' ';cadena[2]=' ';
            llena=0;
            num=0;
            if(pos==4){
                pos=1;}
            else {
                pos++;}
        }
        else if(Keytable[tecla]=='A'){
            llena--;
            cadena[llena]=' ';
            num=strtod(cadena,NULL);
        }
        else if((tecla==0)||(tecla==1)||(tecla==2)||(tecla==4)||(tecla==5)||(tecla==6)||(tecla==8)||(tecla==9)||(tecla==10)||(tecla==13)){
            if(llena<3){
                cadena[llena]=Keytable[tecla];
                num=strtod(cadena,NULL);
                llena++;}
        }
        else if(Keytable[tecla]=='D'){
            lcd.writeCommand(C4);//escribimos un comando segun el manual del modulo LCD para quitar cursor bajo
            lcd.cls(); //borra la pantalla
            lcd.printf("   GUARDADOS!");
            wait(1);  
            lcd.cls();
            lcd.printf(" INICIA EL PID");
            wait(1);
            // se imprimen los parches del control  *****************************************
            lcd.cls();
            lcd.printf("Er=%3.0f",err);
            lcd.locate(8,0);
            lcd.printf("Me=%3.0f",med);
            lcd.locate(0,1);
            lcd.printf("Sp=%d",spnum);
            lcd.locate(8,1);
            lcd.printf("Co=%3.0f",pid);
            wait(2);
            cicloPID:
                if(Keytable[tecla]=='C'){
                    spnum=0;kinum=0;kpnum=0;kdnum=0;llena=0;pos=1;flag1=1;
                    cadena[0]=' ';cadena[1]=' ';cadena[2]=' ';
                    goto ini1;}
                med=y.read()*999;   //leer puerto analogo y asignar a med
                err = (spnum-med);  //se calcula el error        
                ap = kpnum*err;     //se calcula la accion proporcinal        
                if(ai<300){// se verifica que la accion integral no sea muy grande
                    ai =(kinum*err)+ai;}    //calculo de la integral del error
                ad = kdnum*(err-err_v); //calculo de la accion derivativa
                pid = (ap+ai+ad);
                if(pid<=0){// se verifica que pid sea positivo
                    pid=0;}
                if (pid > 999){// se verifica que pid sea menor o igual la valor maximo
                    pid=999;}
                
                if(flagt==0){//se muestran las variables
                    t.start();
                    flagt=1;}
                if(t>=0.3){
                    lcd.locate(3,0);lcd.printf("    ");
                    lcd.locate(3,0);lcd.printf("%3.0f",err);
                    lcd.locate(11,0);lcd.printf("    ");
                    lcd.locate(11,0);lcd.printf("%3.0f",med);
                    lcd.locate(3,1);lcd.printf("    ");
                    lcd.locate(3,1);lcd.printf("%d",spnum);
                    lcd.locate(11,1);lcd.printf("    ");
                    lcd.locate(11,1);lcd.printf("%3.0f",pid);
                    flagt=0;
                    t.reset();
                }
        
                pidn=pid/999;//Normalizacion de la salida
                u.write(pidn);//se envia el valor pid a puerto analogico de salida (D/A)
                wait_ms(100);
                err_v = err;// se actualizan las variables
                goto cicloPID;
        }            
        if(pos==1){
            spnum=num;
            lcd.locate(3,0);lcd.printf("    ");
            lcd.locate(3,0);lcd.printf("%d",spnum);
        }
        else if(pos==2){
            kpnum=num;
            lcd.locate(11,0);lcd.printf("    ");
            lcd.locate(11,0);lcd.printf("%d",kpnum);
        }
        else if(pos==3){
            kinum=num;
            lcd.locate(3,1);lcd.printf("    ");
            lcd.locate(3,1);lcd.printf("%d",kinum);
        }
        else if(pos==4){
            kdnum=num;
            lcd.locate(11,1);lcd.printf("    ");
            lcd.locate(11,1);lcd.printf("%d",kdnum);
        }
    }
    flag1=1;
    goto ini2;        
}