

#include "mbed.h"

#ifndef MBED_GPS_H
#define MBED_GPS_H

/**  A GPS interface for reading from a Globalsat EM-406 GPS Module */
class GPS {
public:

    /** Create the GPS interface, connected to the specified serial port
     */    
    GPS(PinName tx, PinName rx);
    
    /** Sample the incoming GPS data, returning whether there is a lock
     * 
     * @return 1 if there was a lock when the sample was taken (and therefore .longitude and .latitude are valid), else 0
     */
    int sample();
    
    /** The longitude (call sample() to set) */
    float longitude;
    
    /** The latitude (call sample() to set) */
    float latitude;
    
private:
    float trunc(float v);
    void getline();
    
    Serial _gps;
    char msg[256];
    
};

#endif
