/*
Programa de ejemplo para leer y escribir en la flash de la FRDMKL25Z
los datos se escriben y lee del arreglo "data[]"

*/
#include "mbed.h"
#include "FreescaleIAP.h"
Serial pc(USBTX, USBRX);
 
int main() {
    int address = flash_size() - SECTOR_SIZE;           //Write in last sector
    
    int *data = (int*)address;
    pc.printf("Starting\r\n"); 
    erase_sector(address);
    int numbers[10] = {0, 1, 10, 100, 1000, 10000, 1000000, 10000000, 100000000, 1000000000};
    program_flash(address, (char*)&numbers, 40);        //10 integers of 4 bytes each: 40 bytes length
    pc.printf("Resulting flash: \r\n");
    for (int i = 0; i<10; i++)
        pc.printf("%d\r\n", data[i]);
    
    pc.printf("Done\r\n\n");
        
 
    while (true) {
    }
}