//  Programa para enviar desde la FRDMKL25Z un mensaje de texto en formatp PDU
//   Como modem usa un celular SIEMENS a56i
//   ENVIAR -----la palabra "ALARMA 1"
//  

//   OJO CON ESTO
//   conector del siemens cable verde es RX conectelo a PTE0  cable blanco es TX conectelo a PTE1
#include "mbed.h"
#include "DebouncedIn.h"
#include "stdio.h"
#include "string.h"
Timer t;
DigitalOut LedVerde(LED2);
DigitalOut LedRojo(LED1);
DigitalOut LedAzul(LED3);
DebouncedIn button1(PTC12);  //señal que inicia el envio del mensaje
Serial GSM(PTE0,PTE1); //Configura puerto UART de la FRDMKL25Z
Serial pc(USBTX,USBRX);//Configura puerto USB a la consola serial del PC conectado.
void Rx_interrupt();
int position=0;
int lenpack=6;
int longi=0;
char tel[11];
char DE[50];
char buffer[100];
char datos[100];
char NUMBER[13];    
int index;
int count;
int i = 0;
int j = 0;
int c=0;
unsigned char CtrlZ = 0x1A;  // comodin de emision controlZ
bool Flag = false; // bandera 
char r[]=""; //Cadena de recepcion de la trama PDU si se usa!!
char msg[256];
char char1;
//Flush serial para el buffer
void FlushGSM(void) { 
char1 = 0;
 while (GSM.readable()){
     char1 = GSM.getc();}
     return;}

void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    pc.printf("%c\n", GSM.getc());
    
}
 
int readBuffer(char *buffer,int count)
{
    int i=0; 
    t.start();  // start timer
    while(1) {
        while (GSM.readable()) {
            char c = GSM.getc();
            if (c == '\r' || c == '\n') c = '$';
            buffer[i++] = c;
            if(i > count)break;
        }
        if(i > count)break;
        if(t.read() > 3) {
            t.stop();
            t.reset();
            break;
        }
    }
    wait(0.5);
    while(GSM.readable()) {  // display the other thing..
        char c = GSM.getc();
    }
    return 0;
}

/* esta funcion de abajo limpia o borra todo un "buffer" de tamaño "count"
lo revisa uno por un elemento y le mete el caracter null que indica fin de cadena
no retorna nada
*/
//***************************************************************************************
void cleanBuffer(char *buffer, int count)
{
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}
/* esta funcion de abajo envia un comando parametrizado como cadena
*/
//***************************************************************************************
void sendCmd(char *cmd)
{
    GSM.puts(cmd);
}
/* esta funcion de abajo espera la respuesta de un comando que debe ser identica a la cadena "resp" y un tiempo timeout"
si todo sale bien retorna un cero que en la programacion hay que validar
si algo sale mal ( no se parece o se demora mucho )retorna -1 que debera validarse con alguna expresion logica
*/
//***************************************************************************************
int waitForResp(char *resp, int timeout)
{
    int len = strlen(resp);
    int sum=0;
    t.start();

    while(1) {
        if(GSM.readable()) {
            char c = GSM.getc();
            sum = (c==resp[sum]) ? sum+1 : 0;// esta linea de C# sum se incrementa o se hace cero segun c
            if(sum == len)break;  //ya acabo se sale
        }
        if(t.read() > timeout) {  // time out chequea el tiempo minimo antes de salir perdiendo
            t.stop();
            t.reset();
            return -1;
        }
    }
    t.stop();                 // stop timer  antes de retornar
    t.reset();                    // clear timer
    while(GSM.readable()) {      // display the other thing..
        char c = GSM.getc();
    }

    return 0;
}
/* esta funcion de abajo es muy completa e util se encarga de enviar el comando y esperar la respuesta
si todo sale bien retorna un cero(herencia de las funciones contenedoras) que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int sendCmdAndWaitForResp(char *cmd, char *resp, int timeout)
{
    sendCmd(cmd);
    return waitForResp(resp,timeout);
}
/* esta funcion de abajo chequea que el modem este vivo  envia AT y le contesta con OK y espera 2 segundos
*/
//***************************************************************************************
int powerCheck(void)// este comando se manda para verificar si el modem esta vivo o conectado
{
    return sendCmdAndWaitForResp("AT\r\n", "OK", 2);    
}
/* esta funcion de abajo chequea el estado de la sim card
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int checkSIMStatus(void)
{
    char gprsBuffer[30];
    int count = 0;
    cleanBuffer(gprsBuffer,30);
    while(count < 3) {
        sendCmd("AT+CPIN?\r\n");
        readBuffer(gprsBuffer,30);
        if((NULL != strstr(gprsBuffer,"+CPIN: READY"))) {
            break;
        }
        count++;
        wait(1);
    }

    if(count == 3) {
        return -1;
    }
    return 0;
}
/* esta funcion de abajo chequea la calidad de la señal
y si todo sale bien retorna cun el valor de señal util o un -1 si nop es aceptable, en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int checkSignalStrength(void)
{
    char gprsBuffer[100];
    int index,count = 0;
    cleanBuffer(gprsBuffer,100);
    while(count < 3) {
        sendCmd("AT+CSQ\r\n");
        readBuffer(gprsBuffer,25);
        if(sscanf(gprsBuffer, "AT+CSQ$$$$+CSQ: %d", &index)>0) {
            break;
        }
        count++;
        wait(1);
    }
    if(count == 3) {
        return -1;
    }
    return index;
}
/* esta funcion de abajo configura el modem de forma inicial con comandas AT
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica pero si algo sale mal retorna un -1
*/
//***************************************************************************************
/*int settingSMS() //esta funcion se invoca para configurar el modem al principio
{
    if(0 != sendCmdAndWaitForResp("AT\r\n", "OK", 1)) {
        return -1;
    }
    if(0 != sendCmdAndWaitForResp("AT+CNMI=1,1\r\n", "OK", 1)) {
        return -1;
    }
    if(0 != sendCmdAndWaitForResp("AT+CMGF=0\r\n", "OK", 1)) {
        return -1;
    }
    if(0 != sendCmdAndWaitForResp("ATE\r\n", "OK", 1)) {
        return -1;
    }
    if(0 != sendCmdAndWaitForResp("CBST=0,0,1\r\n", "OK", 1)) {
        return -1;
    }
    return 0;
}
*/


/* esta funcion de abajo inicaliza el modem se compone de un grupo de subfunciones ya definidas previamente
primero chequea que este vivo
segundo chequea el estado de la simcard
tercero chequea la intencidad de señal celular
cuarto aplica la configuracion
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int init()
{
    for(int i = 0; i < 3; i++){
        sendCmdAndWaitForResp("AT\r\n", "OK", 1);
        wait(0.5);
    }
    if(0 != checkSIMStatus()) {
        return -1;
    }
    if(checkSignalStrength()<1) {
        return -1;
    }
   
    GSM.attach(&Rx_interrupt, Serial::RxIrq);
    return 0;
}
/* esta funcion de abajo intenta leer un mensaje de texto en formato PDU o HEX
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int readSMSpdu(char *message, int index)
{
    int i = 0;
    char gprsBuffer[100];
    char *p,*s;
    GSM.printf("AT+CMGR=%d\r\n",index);
    cleanBuffer(gprsBuffer,100);
    readBuffer(gprsBuffer,100);
    if(NULL == ( s = strstr(gprsBuffer,"+CMGR"))) {
        return -1;
    }
    if(NULL != ( s = strstr(gprsBuffer,"+32"))) {
        p = s + 6;
        while((*p != '$')&&(i < 5)) {
            message[i++] = *(p++);
        }
        message[i] = '\0';
    }
    return 0;
}
/* esta funcion de abajo borra mensajes SMS del modem
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int deleteSMS(int index)
{
    char cmd[32];
    snprintf(cmd,sizeof(cmd),"AT+CMGD=%d\r\n",index);
    sendCmd(cmd);
    return 0;
}
//***0*********************************************************************************

// Interupt Routine to read in data from serial port
void Rx_interrupt(){
     }
     /*
     readBuffer(buffer,6);
     if(strncmp(buffer, "+CMTI", 5)){
     wait(1);
     GSM.printf("AT+CMGL=%d\r\n",0);
     readBuffer(buffer,100);}
     if(strncmp(buffer, "+CMGL:", 5)){  
     for (i=0;i<31;i++){
     buffer[5+i]=c;  // 32 de basura
     }
     }
     for (i=0;i<10;i++){
     buffer[36+i]=tel[i];  // numero telefonico
     }
     for (i=0;i<18;i++){
     buffer[46+i]=c;  // 18 de basura
     }
     for (i=0;i<2;i++){
     buffer[64+i]=tel[i];  // tamaño de septetos
     }
     for (i=0;i<30;i++){
     buffer[66+i]=DE[i];  // datos en octetos hex
     if (buffer[i]=='\0'){
     }
     */
     

int main(void)
       { 
           
       //NVIC_DisableIRQ(UART1_IRQn);       
       //apagamos los 3 leds
       LedVerde=1;
       LedRojo=1;
       LedAzul=1;
       lenpack=6;  //tamaño de "ALARMA"
       GSM.baud(9600);//configura los baudios de la FRDMKL25Z en 9600
       GSM.format(8,Serial::None,1); //configura el formato de los datos de la UART
       //configuro modem GSM
       GSM.printf("AT\r\n");
       wait(0.5);
       GSM.printf("AT+CNMI=1,1\r\n");
       wait(0.5);
       GSM.printf("AT+CMGF=0\r\n");
       wait(0.5);
       GSM.printf("ATE\r\n");
       wait(0.5);
       GSM.printf("CBST=0,0,1\r\n");
       wait(0.5);  
       LedVerde=0;     
      
       //if(0!= init()){  //se configura y chequea el modem GSM 
       // LedRojo=0;
       //}
       while(1){
        if (button1.falling())
        { LedVerde=1;
          wait(2);
           if (!button1)
           {LedVerde=0;
           index=20;
       //GSM.printf("AT+CNMI=1,1\r\n"); //configuracion inicial del MODEM!
       GSM.printf("AT+CMGS=%d\r\n",index);
       wait(0.2);
       GSM.printf("0011000A9113223717370000AA08416650DA0C8262"); //esto es "ALARMA 1"
       wait(0.5);
       GSM.putc((char)0x1A); //esto es controlZ   
       LedVerde=1;
       LedRojo=0;  //lo prendo
       wait(3);
       LedRojo=1;  //lo apago
       LedVerde=0;          
       }
    
}      
       if(GSM.readable()) {       //USE ESTE FRAGMENTO DE CODIGO PARA LEER LO QUE EL CELULAR RESPONDE
            while(GSM.readable()) {
                char c = GSM.getc();
                buffer[count++] = c;
                if(count == 64) break;
            }
            pc.puts(buffer);
                  
            
            for(int i = 0; i < count; i++) {
                buffer[i] = NULL;
            }
            
            count = 0;
            
            }
   
}
} 

// buffer[i] contiene lo que regresa