/*************************Alarma para una finca*********************************************************
Como modem usa un celular SIEMENS a56i
Envia el mensaje intruso en rionegro
Como modem GSM usa un celular SIEMENS A56i
El conector se distingue asi: 
Cable verde es RX conectelo a PTE0  cable blanco es TX conectelo a PTE1
La alarma se dispara segun la señal de un sensor PIR que se le filtra el ruido
La alarma puede hacer accionamientos como:
Accionamiento Permanente de una sirena
Accionaminto temporizado de una sirena
Accionamiento de un Mensaje de voz reperido y temporizado
*/

#include "mbed.h"
#include "DebouncedIn.h"
#include "stdio.h"
#include "string.h"

int i,ret;
Timer t;
DigitalOut LedVerde(LED2);
DigitalOut LedRojo(LED1);
DigitalOut LedAzul(LED3);
DigitalOut Camara(PTD4);
DigitalOut Sirena(PTA2);
DigitalOut Luces(LED3);
DebouncedIn PIR(PTA13);  //señal que inicia el envio del mensaje
Serial GSM(PTE0,PTE1); //Configura puerto UART de la FRDMKL25Z
Serial pc(USBTX,USBRX);//Configura puerto USB a la consola serial del PC conectado.
char buffer[100];
char resp[6];
char tel[21];
char tam [3];
char msg [15];
//***************************************FUNCIONES EN C*********************
//****************************************************************************************************************
//esta funcion de abajo lee todo un bufer hasta encontrar CR o LF y el resto lo rellena de
//$, count es lo que va a leer.Lo leido lo mete en buffer que es una cadena previamente definida
//incorpora medida de tiempo si se demora mas de tres segundos retorna fracaso con -1
//**************************************************************************************************************** 
int readBuffer(char *buffer,int count)
{
    int i=0; 
    t.start();  // start timer
    while(1) {
        while (GSM.readable()) {
            char c = GSM.getc();
            if (c == '\r' || c == '\n') c = '$';
            buffer[i++] = c;
            if(i > count)break;
        }
        if(i > count)break;
        if(t.read() > 5) {
            t.stop();
            t.reset();
            break;
        }
    }
    wait(0.5);
    while(GSM.readable()) {  // display the other thing..
        char c = GSM.getc();
    }
    return 0;
}
//********************************************************************************
/* esta funcion de abajo limpia o borra todo un "buffer" de tamaño "count"
lo revisa elemento por elemento y le mete el caracter null que indica fin de cadena
no retorna nada
*/
//***************************************************************************************
void cleanBuffer(char *buffer, int count)
{
    for(int i=0; i < count; i++) {
        buffer[i] = 0;
    }
}
/* esta funcion de abajo envia un comando parametrizado como cadena
puede ser un comando tipo AT
*/
//***************************************************************************************
void sendCmd(char *cmd)
{
    GSM.puts(cmd);
}
//****************************************************************************************
/* esta funcion de abajo espera la respuesta de un comando que debe ser identica a la cadena "resp" y un tiempo timeout"
si todo sale bien retorna un cero que en la programacion hay que validar
si algo sale mal ( no se parece o se demora mucho )retorna -1 que debera validarse con alguna expresion logica
*/
//***************************************************************************************
int waitForResp(char *resp, int timeout)
{
    int len = strlen(resp);
    int sum=0;
    t.start();

    while(1) {
        if(GSM.readable()) {
            char c = GSM.getc();
            sum = (c==resp[sum]) ? sum+1 : 0;// esta linea de C# sum se incrementa o se hace cero segun c
            if(sum == len)break;  //ya acabo se sale
        }
        if(t.read() > timeout) {  // time out chequea el tiempo minimo antes de salir perdiendo
            t.stop();
            t.reset();
            return -1;
        }
    }
    t.stop();                 // stop timer  antes de retornar
    t.reset();                    // clear timer
    while(GSM.readable()) {      // display the other thing..
        char c = GSM.getc();
    }

    return 0;
}
/* esta funcion de abajo es muy completa e util se encarga de enviar el comando y esperar la respuesta
si todo sale bien retorna un cero(herencia de las funciones contenedoras) que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int sendCmdAndWaitForResp(char *cmd, char *resp, int timeout)
{
    sendCmd(cmd);
    return waitForResp(resp,timeout);
}
/* esta funcion de abajo chequea que el modem este vivo  envia AT y le contesta con OK y espera 2 segundos
*/
//***************************************************************************************
int powerCheck(void)// este comando se manda para verificar si el modem esta vivo o conectado
{
    return sendCmdAndWaitForResp("AT\r\n", "OK", 2);    
}

/* esta funcion de abajo chequea el estado de la sim card
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int checkSIMStatus(void)
{
    char gprsBuffer[30];
    int count = 0;
    cleanBuffer(gprsBuffer,30);
    while(count < 3) {
        sendCmd("AT+CPIN?\r\n");
        readBuffer(gprsBuffer,30);
        if((NULL != strstr(gprsBuffer,"+CPIN: READY"))) {
            break;
        }
        count++;
        wait(1);
    }

    if(count == 3) {
        return -1;
    }
    return 0;
}
/* esta funcion de abajo chequea la calidad de la señal
y si todo sale bien retorna con el valor de señal util o un -1 si no es aceptable, en la programacion hay que validar
con alguna expresion logica
*/
//***************************************************************************************
int checkSignalStrength(void)
{
    char gprsBuffer[100];
    int index,count = 0;
    cleanBuffer(gprsBuffer,100);
    while(count < 3) {
        sendCmd("AT+CSQ\r\n");
        readBuffer(gprsBuffer,25);
        if(sscanf(gprsBuffer, "AT+CSQ$$$$+CSQ: %d", &index)>0) {
            break;
        }
        count++;
        wait(1);
    }
    if(count == 3) {
        return -1;
    }
    return index;
}

//*********************esta funcion inicializa el modem***************
int init()
{
    if (0 != sendCmdAndWaitForResp("AT\r\n", "OK", 5)){
        return -1;
        }
    if (0 != sendCmdAndWaitForResp("AT+CNMI=1,1\r\n", "OK", 5)){
        return -1;
        }
    if (0 != sendCmdAndWaitForResp("AT+CMGF=0\r\n", "OK", 5)){
        return -1;
        }
    if (0 != sendCmdAndWaitForResp("AT+CBST=0,0,1\r\n", "OK", 5)){
        return -1;
        }
        return 0;
        }

//*****************SE INICIA EL PROGRAMA PRINCIPAL*******************************************************
int main() {
        LedVerde=1;  //APAGO LOS LEDS
        LedRojo=1;
        LedAzul=1;
        LedRojo=0;  // PRENDO EL LED ROJO 
        
//****************CONFIGURAMOS EL MODEM GSM (TELEFONO CELULAR SIEMENS A56i)
inicio1:        
        ret = init();
        if(ret==0){
        LedRojo=1;
        LedVerde=0;
        }
        else{
        wait(5);
        goto inicio1;    
        }
//*******************************************************************************************
//inicia la recepcion de un mensaje de texto
while(1){
       if (GSM.readable()) {
            readBuffer(buffer,6);
            pc.printf("%s\r\n",buffer);
            for(i=0;i<5;i++)
            {
            resp[i]=buffer[i];
            }  
            pc.printf("%s\r\n",resp);
            if(strcmp("$$+CM",resp) == 0){  //COMPARA resp con "+CMTI"
                pc.printf("llegoo MSG\r\n");
                cleanBuffer(buffer,6);
                GSM.printf("AT+CMGL=0");//envio comando para leer mensaje
                GSM.putc(0x0D);//envoi du caractere \n
                pc.printf("AT+CMGL=0\r\n");
        loop1:    if (GSM.readable()) {
                    readBuffer(buffer,100);
                    pc.printf("%s\r\n",buffer);
                    goto seguir1;
                    }
                    goto loop1;
                   //leer telefono
   seguir1:        for(i=0;i<10;i++){
                       tel[i]=buffer[i+50];
                       }
                pc.printf("%s-\r\n",tel);        
                //leer tamaño
                   for(i=0;i<2;i++){
                       tam[i]=buffer[i+78];
                   }
                   pc.printf("%s-\r\n",tam);        
                   //leer mensaje
                    for(i=0;i<14;i++){
                       msg[i]=buffer[i+80];
                   }
                   pc.printf("%s-\r\n",msg);
                   GSM.printf("AT+CMGD=0");//envio comando para borrar mensaje
                   GSM.putc(0x0D);//envoi du caractere \n
                   wait(1);
                   GSM.printf("AT+CMGD=1");//envio comando para borrar mensaje
                   GSM.putc(0x0D);//envoi du caractere \n
                   wait(1);            
                   //decodificar mensaje
                   //comparar mensaje
                   if(strcmp("417658DE0EC700",msg) == 0){  //COMPARA resp con "417658DE0EC700" que es Alarma1
                   LedVerde=1;
                   LedAzul=0;
                   wait(15);
                   LedAzul=1;
                   LedVerde=0;
                   }
                   if(strcmp("417658DE0ECB00",msg) == 0){  //COMPARA resp con "417658DE0ECB00" que es Alarma2
                   LedVerde=1;
                   LedRojo=0;
                   wait(15);
                   LedRojo=1;
                   LedVerde=0;
                   }
                   
                   
                   //ejecurar orden  //ya se ejecuto
                   //08-D6379B1E569763  esto es Voltaje1
                   
                   
                   cleanBuffer(buffer,100);
                               
                }
            }
               

               
         
//***************ALARMA POR ACTIVACION PIR***************************************************         
       if (PIR.falling())
         { 
          wait(1);
          if (!PIR)
           {
              
//**********se envia la palabra Intrusos en rionegro a cuatro telefonos diferentes....
//******Gustavo        
        GSM.printf("AT+CMGS=50\n\r");
        wait_ms(200);
        GSM.printf("0011000A9113223717370000AA2A21970B19CE83926EBABC3E7FCF41453788190699D3EE7118442E83A4E9B7BB7C96BF5DAE10");
        wait_ms(200);
        GSM.putc((char)0x1A);
        wait(10);
        ///si el operador contesta con mensaje borrar de nuevo
                   GSM.printf("AT+CMGD=0");//envio comando para borrar mensaje
                   GSM.putc(0x0D);//envoi du caractere \n
                   wait(1);
                   GSM.printf("AT+CMGD=1");//envio comando para borrar mensaje
                   GSM.putc(0x0D);//envoi du caractere \n
                   wait(1);
        
        }
        }

        
}//   while        
}//   main
/*
//      P          
/*      GSM.printf("AT+CMGS=50\n\r");
        wait_ms(200);
        GSM.printf("0011000A91-00000000-0000AA2A21970B19CE83926EBABC3E7FCF41453788190699D3EE7118442E83A4E9B7BB7C96BF5DAE10");
        wait_ms(200);
        GSM.putc((char)0x1A);
//      Y        
        GSM.printf("AT+CMGS=50\n\r");
        wait_ms(200);
        GSM.printf("0011000A91-00000000-0000AA2A21970B19CE83926EBABC3E7FCF41453788190699D3EE7118442E83A4E9B7BB7C96BF5DAE10");
        wait_ms(200);
        GSM.putc((char)0x1A);
//      S        
        GSM.printf("AT+CMGS=50\n\r");
        wait_ms(200);
        GSM.printf("0011000A91-00000000-0000AA2A21970B19CE83926EBABC3E7FCF41453788190699D3EE7118442E83A4E9B7BB7C96BF5DAE10");
        wait_ms(200);
        GSM.putc((char)0x1A);

        wait(30);         
}
}
}  //while
} //main

/*
Camara on

da esto
 +CMGL: 1,0,,26
0791751330512411040AA1132237173700006150709060250A09C3703B2C0F83DE6E

Camara of da esto
+CMGL: 2,0,,26
0791751330080089040AA1132237173700006150709001520A09C3703B2C0F83DE66

OK

Sirena on
da esto

+CMGL: 3,0,,26
0791751330512411040AA1132237173700006150709031540A09D3B4BCEC0E83DE6E

OK

Sirena of

da esto
+CMGL: 4,0,,26
0791751330512411040AA1132237173700006150709051750A09D3B4BCEC0E83DE66

OK

Alarma 1

+CMGL: 1,0,,25
0791751330512411040AA1132237173700006150702153640A08417658DE0E8362
5



*/