/*
Este programa se escribe para un sistema de alarmas de una Finca.
dispone de tres sensores PIR instalados en tres partes de la finca: adelante, atras
y vigilan un plato de directTV.
se instalaron tres camaras para gravar video 
la alarma tiene sirena de potencia
con la deteccion de cualquier PIR se acciona su camara respectiva de su zona y 
la sirena por un minuto
Los sensores se captan en modo interupcion
el sensor normalmente tiene una resistencia baja en la salida (10-50 ohmios)
cuando hay señal o objeto detectado la resistencia es muy alta casi infinita
ese valor se conserva durante tres segundos y vuelve a ser baja.
el programa espera que la señal sea estable en un periodo de 600mS
si el pulso es mas corto ignora la alarma para evitar falsos disparos
mas adelante le incorporaremos enviar mensajes por modem GSM
la prueba se hace al pulso bajo
para pulso alto cambiar a "rise" la configuracion de la interupcion
y las lineas parecidas a estas de abajo
asi: if(!PIR_PORTON){ para los de caida  (con fall)
asi: if(PIR_PORTON){  para los de subida (con rise)

*/

#include "mbed.h"
int porton,trasera,plato;
int espera=600;


//interupcion de sensores pir instalados
InterruptIn PIR_PORTON(PTA12); //piroelectrico de entrada principal
InterruptIn PIR_TRASERO(PTA13);//piroeelectrico de ventana de atras 
InterruptIn PIR_PLATO(PTA17);//piroelectrico del plato DIRECtv
InterruptIn button(PTD4);

//Salidas para activar Camaras
DigitalOut Camara_porton(PTB1);
DigitalOut Camara_trasera(PTB2);
DigitalOut Camara_plato(PTB3);

//salidas para el parlante;
DigitalOut sirena(PTB4);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut flash(LED3);

//las interupciones se disparan por flanco de caida de los sensores pir
//para filtrar falsos disparos se determina si la señal del pir alcanza el tiempo minimo 
//llamado "espera"  en ms.
//se usan las banderas: porton, plato, trasera para determinar que alarma se activa

//interupcion por deteccion PIR del porton 
void Pir_Del(){
    wait_ms(espera);
    if(!PIR_PORTON){
    porton=1;
    return;
    }
}

//interupcion por deteccion PIR trasero 
void Pir_Tras() {
    wait_ms(espera);
    if(!PIR_TRASERO){
    trasera=1;
    return;
    }    
}

//interupcion por deteccion PIR plato 
void Pir_Plato() {
    wait_ms(espera);
    if(!PIR_PLATO){
    plato=1;
    return;
    }    
}

//ciclo principal;
 
int main(){
      led1=1;
      led2=1;
      led3=1;
      led1=0;
      wait(2);
      led1=1;
    //declaracion de las tres interupciones  
    PIR_PORTON.fall(&Pir_Del);    
    PIR_TRASERO.fall(&Pir_Tras);  
    PIR_PLATO.fall(&Pir_Plato);  
    
    while(1) {           
        if(porton){
        Camara_porton=1;
        sirena=1;
        led1=0;
        wait(60);
        Camara_porton=0;
        sirena=0;
        led1=1;
        porton=0;
        }
        
        
        if(trasera){
        Camara_trasera=1;
        sirena=1;
        led2=0;
        wait(60);
        Camara_trasera=0;
        sirena=0;
        led2=1;
        trasera=0; 
        }
        
        if(plato){
        Camara_plato=1;
        sirena=1;
        led3=0;
        wait(60);
        Camara_plato=0;
        sirena=0;
        led3=1;
        plato=0;   
        }
        
   }//while



//****************************************************    
}//main
