
//==============================================================
//  Morse Code  June 30, 2011  John H. Fisher - K5JHF
//==============================================================

#ifndef  MORSE_CODE_H
#define  MORSE_CODE_H

#include "Goodies.h"

#define PI 3.141592654

#define step PI/16

extern const float sine_wave [ 32 ];

class  Morse_Code : private Goodies  {
    
//===================================================================

private:

    float  u, _WPM_Character, _WPM_Speed, ta, tc, tw;

    int    _Tone_Frequency;
    
    char   _LED_Pin,  _Speaker_Pin;

//===================================================================

    struct {
       
        int  last_bit:1;
        
        int  last_char:1;
        
        int  _Sound:1;  
        
        int  _Practice:1;  
        
      } Morse_Flag;

//===================================================================

    public:
    
        Morse_Code  (   float  WPM_Character  = 18.0,
                        float  WPM_Speed      =  5.0,
                        int    Tone_Frequency =  700,
                        char   LED_Pin        =   11,
                        char   Speaker_Pin    =    9  );
                        
        void    Sound_On ( void );                

        void    Sound_Off ( void ); 

        void    Sound_Toggle ( void );        

        void    Practice_On ( void );                

        void    Practice_Off ( void ); 

        void    Practice_Toggle ( void ); 
 
        int    get_Practice ( void );       

        char  Morse ( char ASCII );

        void  Send_Morse ( char Morse );

        char  Random_Code ( void );
        
        void  set_Tone ( int  frequency );        
        
        int   get_Tone ( );        
        
        void  Tone_Adjust  ( int  delta,  int limit );
        
        void  set_WPM ( float WPM_Speed );        
        
        float get_WPM ( );        
        
        void  WPM_Adjust  (  float delta, float limit );

    private:

        void  Calculate_Morse_Timing ( float s, float c ) ;

        void  dit  ( );

        void  dah  ( );
        
        void  Tone ( int freq_factor, float duration ) ;

    };
      
//===================================================================

#endif

//===================================================================


