#include "mbed.h"
#include "LSM9DS1.h"

Serial pc(USBTX, USBRX);
LSM9DS1 imu(I2C_SDA0, I2C_SCL0);
Timer timer;
AnalogIn Analog1(P0_5);
AnalogIn Analog2(P0_6);
int acc[3];
int gyro[3];
float strain[2];

int main() {
    pc.baud(115200);
    timer.start();
    while(1){
        imu.getAcceleroRaw(acc);
        imu.getGyroRaw(gyro);
        strain[0] = Analog1.read();
        strain[1] = Analog2.read();
        pc.printf("%d,%d,%d,%d,%d,%d,%d,%.5f,%.5f",timer.read_ms(),acc[0],acc[1],acc[2],gyro[0],gyro[1],gyro[2],strain[0],strain[1]);
        pc.printf("\n");
    }
}
