/**
 * Includes
 */
#include "LSM9DS1.h"

LSM9DS1::LSM9DS1(PinName sda, PinName scl) : connection(sda, scl) {
    //Initializations:
    this->setSleepMode(false);
    this->initCTRL_REG1_G();
//    this->initORIENT_CFG_G();
//    this->initCTRL_REG4();
    this->initCTRL_REG6_XL();
    currentGyroRange = 0;
    currentAcceleroRange = 0;
}

//--------------------------------------------------
//-------------------General------------------------
//--------------------------------------------------

void LSM9DS1::write(char address, char data) {
    char temp[2];
    temp[0]=address;
    temp[1]=data;
    
    connection.write(LSM9DS1_ADDRESS * 2,temp,2);
}

char LSM9DS1::read(char address) {
    char retval;
    connection.write(LSM9DS1_ADDRESS * 2, &address, 1, true);
    connection.read(LSM9DS1_ADDRESS * 2, &retval, 1);
    return retval;
}

void LSM9DS1::read(char address, char *data, int length) {
    connection.write(LSM9DS1_ADDRESS * 2, &address, 1, true);
    connection.read(LSM9DS1_ADDRESS * 2, data, length);
}

bool LSM9DS1::testConnection( void ) {
    char temp;
    temp = this->read(LSM9DS1_WHO_AM_I_REG);
    return (temp == (LSM9DS1_ADDRESS & 0x68));
}

void LSM9DS1::setSleepMode(bool state) {
    char temp;
    temp = this->read(LSM9DS1_CTRL_REG9);
    if (state == true)
        temp |= 1<<LSM9DS1_SLP_BIT;
    if (state == false)
        temp &= ~(1<<LSM9DS1_SLP_BIT);
    this->write(LSM9DS1_CTRL_REG9 , temp);
}

void LSM9DS1::initCTRL_REG1_G( void ){
    this->write(LSM9DS1_CTRL_REG1_G, 0xC3);
}

void LSM9DS1::initORIENT_CFG_G( void ){
    this->write(LSM9DS1_ORIENT_CFG_G, 0x38);
}

void LSM9DS1::initCTRL_REG4( void ){
    this->write(LSM9DS1_CTRL_REG4, 0x39);
}

void LSM9DS1::initCTRL_REG6_XL( void ){
    this->write(LSM9DS1_CTRL_REG6_XL, 0xC3);
}


//--------------------------------------------------
//----------------Accelerometer---------------------
//--------------------------------------------------

void LSM9DS1::setAcceleroRange( char range ) {
    char temp;
    range = range & 0x03;
    currentAcceleroRange = range;
    temp = this->read(LSM9DS1_CTRL_REG6_XL);
    temp &= ~(3<<3);
    temp = temp + (range<<3);
    this->write(LSM9DS1_CTRL_REG6_XL, temp);
}

int LSM9DS1::getAcceleroRawX( void ) {
    short retval;
    char data[2];
    this->read(LSM9DS1_ACCEL_XOUT_L_REG, data, 2);
    retval = (data[1]<<8) + data[0];
    return (int)retval;
}
    
int LSM9DS1::getAcceleroRawY( void ) {
    short retval;
    char data[2];
    this->read(LSM9DS1_ACCEL_YOUT_L_REG, data, 2);
    retval = (data[1]<<8) + data[0];
    return (int)retval;
}

int LSM9DS1::getAcceleroRawZ( void ) {
    short retval;
    char data[2];
    this->read(LSM9DS1_ACCEL_ZOUT_L_REG, data, 2);
    retval = (data[1]<<8) + data[0];
    return (int)retval;
}

void LSM9DS1::getAcceleroRaw( int *data ) {
    char temp[6];
    this->read(LSM9DS1_ACCEL_XOUT_L_REG, temp, 6);
    data[0] = (int)(short)((temp[1]<<8) + temp[0]);
    data[1] = (int)(short)((temp[3]<<8) + temp[2]);
    data[2] = (int)(short)((temp[5]<<8) + temp[4]);
}


//--------------------------------------------------
//------------------Gyroscope-----------------------
//--------------------------------------------------

void LSM9DS1::setGyroRange( char range ) {
    char temp;
    currentGyroRange = range;
    range = range & 0x03;
    temp = this->read(LSM9DS1_CTRL_REG1_G);
    temp &= ~(3<<3);
    temp = temp + range<<3;
    this->write(LSM9DS1_CTRL_REG1_G, temp);
}

int LSM9DS1::getGyroRawX( void ) {
    short retval;
    char data[2];
    this->read(LSM9DS1_GYRO_XOUT_L_REG, data, 2);
    retval = (data[1]<<8) + data[0];
    return (int)retval;
}
    
int LSM9DS1::getGyroRawY( void ) {
    short retval;
    char data[2];
    this->read(LSM9DS1_GYRO_YOUT_L_REG, data, 2);
    retval = (data[1]<<8) + data[0];
    return (int)retval;
}

int LSM9DS1::getGyroRawZ( void ) {
    short retval;
    char data[2];
    this->read(LSM9DS1_GYRO_ZOUT_L_REG, data, 2);
    retval = (data[1]<<8) + data[0];
    return (int)retval;
}

void LSM9DS1::getGyroRaw( int *data ) {
    char temp[6];
    this->read(LSM9DS1_GYRO_XOUT_L_REG, temp, 6);
    data[0] = (int)(short)((temp[1]<<8) + temp[0]);
    data[1] = (int)(short)((temp[3]<<8) + temp[2]);
    data[2] = (int)(short)((temp[5]<<8) + temp[4]);
}
