#include "mbed.h"

/*
1 vcc - 3v3
2 gnd - gnd
3 sce - A0
4 rst - A1
5 d/c - A2
6 dn - A3
7 sclk - A4
8 led - 3v3
*/

DigitalOut LCD_PIN_CLOCK(A4); //sclk
DigitalOut LCD_PIN_DATA(A3); // dn
DigitalOut LCD_PIN_COMMAND(A2); // d/c
DigitalOut LCD_PIN_RESET(A1); // rst
DigitalOut LCD_PIN_ENABLE(A0); // sce

#define LCD_CMD             0
#define LCD_DATA            1

static const uint8_t ASCII[][5] =
{
 {0x00, 0x00, 0x00, 0x00, 0x00} // 20  
,{0x00, 0x00, 0x5f, 0x00, 0x00} // 21 !
,{0x00, 0x07, 0x00, 0x07, 0x00} // 22 "
,{0x14, 0x7f, 0x14, 0x7f, 0x14} // 23 #
,{0x24, 0x2a, 0x7f, 0x2a, 0x12} // 24 $
,{0x23, 0x13, 0x08, 0x64, 0x62} // 25 %
,{0x36, 0x49, 0x55, 0x22, 0x50} // 26 &
,{0x00, 0x05, 0x03, 0x00, 0x00} // 27 '
,{0x00, 0x1c, 0x22, 0x41, 0x00} // 28 (
,{0x00, 0x41, 0x22, 0x1c, 0x00} // 29 )
,{0x14, 0x08, 0x3e, 0x08, 0x14} // 2a *
,{0x08, 0x08, 0x3e, 0x08, 0x08} // 2b +
,{0x00, 0x50, 0x30, 0x00, 0x00} // 2c ,
,{0x08, 0x08, 0x08, 0x08, 0x08} // 2d -
,{0x00, 0x60, 0x60, 0x00, 0x00} // 2e .
,{0x20, 0x10, 0x08, 0x04, 0x02} // 2f /
,{0x3e, 0x51, 0x49, 0x45, 0x3e} // 30 0
,{0x00, 0x42, 0x7f, 0x40, 0x00} // 31 1
,{0x42, 0x61, 0x51, 0x49, 0x46} // 32 2
,{0x21, 0x41, 0x45, 0x4b, 0x31} // 33 3
,{0x18, 0x14, 0x12, 0x7f, 0x10} // 34 4
,{0x27, 0x45, 0x45, 0x45, 0x39} // 35 5
,{0x3c, 0x4a, 0x49, 0x49, 0x30} // 36 6
,{0x01, 0x71, 0x09, 0x05, 0x03} // 37 7
,{0x36, 0x49, 0x49, 0x49, 0x36} // 38 8
,{0x06, 0x49, 0x49, 0x29, 0x1e} // 39 9
,{0x00, 0x36, 0x36, 0x00, 0x00} // 3a :
,{0x00, 0x56, 0x36, 0x00, 0x00} // 3b ;
,{0x08, 0x14, 0x22, 0x41, 0x00} // 3c <
,{0x14, 0x14, 0x14, 0x14, 0x14} // 3d =
,{0x00, 0x41, 0x22, 0x14, 0x08} // 3e >
,{0x02, 0x01, 0x51, 0x09, 0x06} // 3f ?
,{0x32, 0x49, 0x79, 0x41, 0x3e} // 40 @
,{0x7e, 0x11, 0x11, 0x11, 0x7e} // 41 A
,{0x7f, 0x49, 0x49, 0x49, 0x36} // 42 B
,{0x3e, 0x41, 0x41, 0x41, 0x22} // 43 C
,{0x7f, 0x41, 0x41, 0x22, 0x1c} // 44 D
,{0x7f, 0x49, 0x49, 0x49, 0x41} // 45 E
,{0x7f, 0x09, 0x09, 0x09, 0x01} // 46 F
,{0x3e, 0x41, 0x49, 0x49, 0x7a} // 47 G
,{0x7f, 0x08, 0x08, 0x08, 0x7f} // 48 H
,{0x00, 0x41, 0x7f, 0x41, 0x00} // 49 I
,{0x20, 0x40, 0x41, 0x3f, 0x01} // 4a J
,{0x7f, 0x08, 0x14, 0x22, 0x41} // 4b K
,{0x7f, 0x40, 0x40, 0x40, 0x40} // 4c L
,{0x7f, 0x02, 0x0c, 0x02, 0x7f} // 4d M
,{0x7f, 0x04, 0x08, 0x10, 0x7f} // 4e N
,{0x3e, 0x41, 0x41, 0x41, 0x3e} // 4f O
,{0x7f, 0x09, 0x09, 0x09, 0x06} // 50 P
,{0x3e, 0x41, 0x51, 0x21, 0x5e} // 51 Q
,{0x7f, 0x09, 0x19, 0x29, 0x46} // 52 R
,{0x46, 0x49, 0x49, 0x49, 0x31} // 53 S
,{0x01, 0x01, 0x7f, 0x01, 0x01} // 54 T
,{0x3f, 0x40, 0x40, 0x40, 0x3f} // 55 U
,{0x1f, 0x20, 0x40, 0x20, 0x1f} // 56 V
,{0x3f, 0x40, 0x38, 0x40, 0x3f} // 57 W
,{0x63, 0x14, 0x08, 0x14, 0x63} // 58 X
,{0x07, 0x08, 0x70, 0x08, 0x07} // 59 Y
,{0x61, 0x51, 0x49, 0x45, 0x43} // 5a Z
,{0x00, 0x7f, 0x41, 0x41, 0x00} // 5b [
,{0x02, 0x04, 0x08, 0x10, 0x20} // 5c ¥
,{0x00, 0x41, 0x41, 0x7f, 0x00} // 5d ]
,{0x04, 0x02, 0x01, 0x02, 0x04} // 5e ^
,{0x40, 0x40, 0x40, 0x40, 0x40} // 5f _
,{0x00, 0x01, 0x02, 0x04, 0x00} // 60 `
,{0x20, 0x54, 0x54, 0x54, 0x78} // 61 a
,{0x7f, 0x48, 0x44, 0x44, 0x38} // 62 b
,{0x38, 0x44, 0x44, 0x44, 0x20} // 63 c
,{0x38, 0x44, 0x44, 0x48, 0x7f} // 64 d
,{0x38, 0x54, 0x54, 0x54, 0x18} // 65 e
,{0x08, 0x7e, 0x09, 0x01, 0x02} // 66 f
,{0x0c, 0x52, 0x52, 0x52, 0x3e} // 67 g
,{0x7f, 0x08, 0x04, 0x04, 0x78} // 68 h
,{0x00, 0x44, 0x7d, 0x40, 0x00} // 69 i
,{0x20, 0x40, 0x44, 0x3d, 0x00} // 6a j 
,{0x7f, 0x10, 0x28, 0x44, 0x00} // 6b k
,{0x00, 0x41, 0x7f, 0x40, 0x00} // 6c l
,{0x7c, 0x04, 0x18, 0x04, 0x78} // 6d m
,{0x7c, 0x08, 0x04, 0x04, 0x78} // 6e n
,{0x38, 0x44, 0x44, 0x44, 0x38} // 6f o
,{0x7c, 0x14, 0x14, 0x14, 0x08} // 70 p
,{0x08, 0x14, 0x14, 0x18, 0x7c} // 71 q
,{0x7c, 0x08, 0x04, 0x04, 0x08} // 72 r
,{0x48, 0x54, 0x54, 0x54, 0x20} // 73 s
,{0x04, 0x3f, 0x44, 0x40, 0x20} // 74 t
,{0x3c, 0x40, 0x40, 0x20, 0x7c} // 75 u
,{0x1c, 0x20, 0x40, 0x20, 0x1c} // 76 v
,{0x3c, 0x40, 0x30, 0x40, 0x3c} // 77 w
,{0x44, 0x28, 0x10, 0x28, 0x44} // 78 x
,{0x0c, 0x50, 0x50, 0x50, 0x3c} // 79 y
,{0x44, 0x64, 0x54, 0x4c, 0x44} // 7a z
,{0x00, 0x08, 0x36, 0x41, 0x00} // 7b {
,{0x00, 0x00, 0x7f, 0x00, 0x00} // 7c |
,{0x00, 0x41, 0x36, 0x08, 0x00} // 7d }
,{0x10, 0x08, 0x08, 0x10, 0x08} // 7e ←
,{0x00, 0x06, 0x09, 0x09, 0x06} // 7f →
};

static uint8_t bender [] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8,
0xFC, 0xFF, 0xDF, 0xAF, 0x55, 0x80, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00,
0x55, 0x00, 0x55, 0x00, 0x55, 0x80, 0xD5, 0x80, 0xD5, 0xE0, 0xF5, 0x60, 0x75, 0x70, 0x75, 0x60,
0x75, 0xE0, 0xD5, 0x80, 0xD5, 0x00, 0x55, 0x00, 0x55, 0x00, 0x57, 0x07, 0x5E, 0x3C, 0x70, 0xF0,
0xE0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x03, 0x5F, 0xFF, 0xFF, 0xFF, 0xD7, 0xEE, 0xD5, 0xE8, 0xD5, 0xA0, 0xD5, 0x80,
0xD5, 0xC0, 0xF5, 0xE0, 0xBD, 0xF8, 0xDF, 0xEE, 0x7F, 0x3B, 0x3F, 0x0F, 0x0F, 0x06, 0x06, 0x06,
0x06, 0x06, 0x0C, 0x0C, 0x38, 0x38, 0xF1, 0xC1, 0xC3, 0x07, 0x07, 0x3C, 0x3D, 0xF8, 0xF5, 0xC0,
0x55, 0x00, 0x55, 0x00, 0x55, 0x03, 0x57, 0x1E, 0x7C, 0xF0, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0xC7, 0xFF, 0xFD, 0x7A,
0xDD, 0xFE, 0xFF, 0x77, 0x7F, 0x3C, 0x7E, 0x3F, 0x3F, 0x3F, 0x7F, 0xFF, 0x80, 0x80, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0F, 0x8F, 0xC4, 0xE0, 0x7D, 0x3F, 0x1F, 0x00, 0x00, 0x00,
0x80, 0x80, 0xE1, 0xE7, 0x7F, 0x3E, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x01,
0x57, 0x0F, 0x5C, 0x78, 0x70, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xE0, 0xF0, 0xBC, 0xDF, 0xEF,
0xF7, 0xFF, 0xFF, 0xFF, 0x47, 0x03, 0x01, 0x00, 0x00, 0x00, 0xC0, 0xE0, 0xF0, 0xE0, 0x00, 0x01,
0x07, 0x07, 0x0E, 0xCC, 0xCC, 0xFC, 0x7C, 0x3C, 0x1C, 0x0E, 0x07, 0x83, 0xC1, 0xE0, 0x70, 0x30,
0x78, 0x1C, 0x5C, 0x0F, 0x57, 0x03, 0xD5, 0xC0, 0xD5, 0xE0, 0x75, 0x30, 0x35, 0xB8, 0xDD, 0xF8,
0xFD, 0xF8, 0xFD, 0xB8, 0x35, 0x30, 0xF5, 0xC0, 0xD5, 0x03, 0x57, 0x0F, 0x5F, 0xBC, 0xF0, 0xF0,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF,
0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFC, 0xF8, 0xF0, 0xF0, 0xF0, 0xE1,
0xF1, 0xF0, 0x78, 0xB8, 0x5E, 0x2E, 0x57, 0x81, 0xD1, 0xE8, 0xF4, 0xB8, 0xFC, 0xBE, 0x77, 0xA3,
0x55, 0x80, 0xD5, 0xC0, 0xF5, 0x78, 0x3D, 0xBE, 0xFF, 0xE6, 0xF3, 0xF9, 0x1D, 0x0D, 0x07, 0x07,
0x0F, 0xF9, 0xF9, 0xF0, 0xF0, 0xB8, 0x19, 0x1F, 0xC6, 0xCE, 0xFB, 0xFB, 0x7F, 0xE8, 0xF5, 0xFE,
0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x07, 0x0F, 0x1F, 0x1F, 0x1F, 0x3B, 0x77, 0x7F, 0x7F, 0x6F, 0x7F, 0x7F,
0x7F, 0x3F, 0x3F, 0x3B, 0x1D, 0x1C, 0x1D, 0x1E, 0x1F, 0x0E, 0x1F, 0x0F, 0x1F, 0x3F, 0x7D, 0xEE,
0xFF, 0xFE, 0xF7, 0xEA, 0x7F, 0x7F, 0x7F, 0x3F, 0x1F, 0x1E, 0x7F, 0xE3, 0xC1, 0xE0, 0xF1, 0x73,
0x1F, 0x1E, 0x9F, 0xFB, 0xF3, 0x60, 0x70, 0xFC, 0xDD, 0xEF, 0xD7, 0xE3, 0xD7, 0xE1, 0xD5, 0xF8,
0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
};

void lcdWrite(uint8_t dataOrCommand, uint8_t value)
{
  if (dataOrCommand)
    LCD_PIN_COMMAND = 1;
  else
    LCD_PIN_COMMAND = 0;

  LCD_PIN_ENABLE = 0;

  int i;
  for (i = 0; i < 8; i++)
  {
    LCD_PIN_CLOCK = 0;
    if (value & 0x80)
      LCD_PIN_DATA = 1;
    else
      LCD_PIN_DATA = 0;
    value <<= 1;
    LCD_PIN_CLOCK=1;

  }

  LCD_PIN_ENABLE = 1;
}

void lcdBender(void)
{
  for ( int i = 0; i < ( 84 * 48 ) / 8; i++)
  {
    lcdWrite(LCD_DATA, bender[i]);
  }
}

void lcdInit()
{
    // Reset LCD
  
  LCD_PIN_RESET = 1;
  wait_ms(10);
  LCD_PIN_RESET = 0;
  wait_ms(10);
  LCD_PIN_RESET = 1;

  // Initialize LCD state
  lcdWrite(LCD_CMD, 0x21); // LCD Extended Commands.
  lcdWrite(LCD_CMD, 0xB1); // Set LCD Vop (Contrast).
  lcdWrite(LCD_CMD, 0x04); // Set Temp coefficent.
  lcdWrite(LCD_CMD, 0x15); // LCD bias mode
  lcdWrite(LCD_CMD, 0x20);
  lcdWrite(LCD_CMD, 0x0C); // LCD in normal mode.    
}

void lcdXY( uint8_t x, uint8_t y)
{
  lcdWrite( 0, 0x80 | x);
  lcdWrite( 0, 0x40 | y);
}

void lcdChar(char ch)
{
  lcdWrite( LCD_DATA, 0x00);
  for ( int i = 0; i < 5; i++)
  {
    lcdWrite(LCD_DATA, ASCII[ch - 0x20][i]);
  }
  lcdWrite( LCD_DATA, 0x00);
}

void lcdGlyph( uint8_t glyph[] )
{
  lcdWrite( LCD_DATA, 0x00);
  for ( int i = 0; i < 5; i++)
  {
    lcdWrite(LCD_DATA, glyph[i]);
  }
  lcdWrite( LCD_DATA, 0x00);  
}

void lcdClear(void)
{
  for ( int i = 0; i < ( 84 * 48 ) / 8; i++)
  {
    lcdWrite(LCD_DATA, 0x00);
  }
}

void lcdStr( char *msg )
{
  while (*msg)
  {
    lcdChar(*msg++);
  }
}

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX);
 
DigitalOut myled(LED1);
 
int main() {
  
  lcdInit();
  
  lcdClear();
  lcdXY(0,0);
  lcdBender();  
  
 // lcdXY( 1, 2 );
//  lcdStr( "Hello World");
  
  while(1) { 
      wait(1);
      myled = !myled;
  }
}
 