/*
 * cube.h
 * April 11, 2017
 * 
 * Control software for balancing cube senior design project
 *
 * Will Church
 * Tom Rasmussen
 */
 
#ifndef CUBE_H
#define CUBE_H

/* -- INCLUDES -- */
#include "mbed.h"
#include "BNO055.h"

/* -- STRUCT -- */
struct config {
    double      Kbt;        // Body angle gain
    double      Kbv;        // Body velocity gain
    double      Kwv;        // Wheel velocity gain
    double      eqAngle;    // Equilibrium angle
    double      *angle;     // Points to angle in IMU Euler_angle struct
    double      *vel;       // Points to vel in IMU VEL struct
    PwmOut      *pwm;       // PWM out for motor control
    AnalogIn    *hall;      // Analog in for wheel velocity
    char        *descr;      // Description of config
};

/* -- GLOBALS -- */
Ticker pwmint;                              // Button interrupt
BNO055_EULER_TypeDef    euler_angles;
BNO055_VEL_TypeDef      velocity;
config *currentConfig;                      // Stores current config
bool isActive;                              // Control loop bool

/* -- CONSTANTS -- */
const double pi = 3.14159265;
const float TM = .25;  //threshold for main axis
const float TA = .2;   //threshold for aux axis

/* -- CONFIGS -- */
/* Define our parameters here for each balancing configuration */
struct config balX = {-89.9276,            //Kbt
                       -14.9398,            //Kbv
                       -0.001,              //Kwv
                       pi/4.0,              //eqAngle
                       &(euler_angles.r),   //angle
                       &(velocity.x),       //vel
                       new PwmOut(PE_9),    //pwm
                       new AnalogIn(A0),    //hall
                       "Balancing on X edge"};   //descr
                       
struct config balY = {0,            //Kbt
                       0,            //Kbv
                       0,              //Kwv
                       -pi/4.0,              //eqAngle
                       &(euler_angles.p),   //angle
                       &(velocity.y),       //vel
                       new PwmOut(PE_9),    //pwm
                       new AnalogIn(A0),    //hall
                       "Balancing on Y edge"};   //descr

struct config balZ = {-72.4921,            //Kbt
                       -9.9672,            //Kbv
                       -0.00025,              //Kwv
                       -.7000,              //eqAngle
                       &(euler_angles.p),   //angle
                       &(velocity.z),       //vel
                       new PwmOut(PE_9),    //pwm
                       new AnalogIn(A0),    //hall
                       "Balancing on Z edge"};   //descr

struct config fall = {0,            //Kbt
                       0,            //Kbv
                       0,              //Kwv
                       0,              //eqAngle
                       &(euler_angles.p),   //angle
                       &(velocity.z),       //vel
                       NULL,    //pwm
                       NULL,    //hall
                       "Fallen"};   //descr

// Other constants


/* -- NOTES -- */
//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

/* -- PROTOTYPES -- */

/*
 * Checks and prints calibration until sys calib is at 3 / 3
 */
//void checkCalib(BNO055 *imu, Serial *pc);

/*
 * TODO: Documentation here
 * Note: should this function be inline?
 */
double calcPWM(config *c);
void updatePWM(config *c);
#endif