/*
 * cube.h
 * April 11, 2017
 * 
 * Control software for balancing cube senior design project
 *
 * Will Church
 * Tom Rasmussen
 */
 
#ifndef CUBE_H
#define CUBE_H

/* -- INCLUDES -- */
#include "mbed.h"
#include "BNO055.h"

/* -- STRUCT -- */
struct config {
    double      Kbt;        // Body angle gain
    double      Kbv;        // Body velocity gain
    double      Kwv;        // Wheel velocity gain
    double      eqAngle;    // Equilibrium angle
    double      *angle;     // Points to angle in IMU Euler_angle struct
    double      *vel;       // Points to vel in IMU VEL struct
    PwmOut      *pwm;       // PWM out for motor control
    AnalogIn    *hall;      // Analog in for wheel velocity
    char        *descr;      // Description of config
};

/* -- CONSTANTS -- */
// 1D gains, other wheels detached
/*const double Kbt = -89.9276;
const double Kbv = -14.9398;
const double Kwv =  -0.001; //-0.0909;

1d gains, others wheels attached
const double Kbt_x = 0;
const double Kbv_x = 0;
const double Kwv_x = 0;

const double Kbt_y = 0;
const double Kbv_y = 0;
const double Kwv_y = 0;

const double Kbt_z = 0;
const double Kbv_z = 0;
const double Kwv_z = 0;*/

// Other constants
const double pi = 3.14159265;

/* -- NOTES -- */
//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

/* -- PROTOTYPES -- */

/*
 * Checks and prints calibration until sys calib is at 3 / 3
 */
void checkCalib(BNO055 *imu, Serial *pc);

/*
 * TODO: Documentation here
 * Note: should this function be inline?
 */
double calcPWM(config *c);
void updatePWM(config *c);
#endif