/*
    AM2321 Temperature and Humidity Sensor
    mbed Sample code
    
    Copyright (c) 2014 tomozh <tomozh@gmail.com>
    
    This software is released under the MIT License.
    http://opensource.org/licenses/mit-license.php

    Last update : 2014/05/06
*/

#include "mbed.h"
#include "AM2321.h"

Serial pc(USBTX, USBRX);    // Tx, Rx
AM2321 am2321(p28, p27);    // SDA, SCL
DigitalOut led1(LED1);

int main()
{
    uint16_t count = 0;
   
    while(1)
    {
        led1 = !led1;

        if(am2321.poll())
        {
            pc.printf(
                  ":%05u,%.1f,%.1f\n"
                , count++
                , am2321.getTemperature()
                , am2321.getHumidity()
            );
        }

        wait(0.5);
    }
    
    /*
        output
        -----------------------
        :01100,23.7,38.1
        :01101,23.6,38.0
        :01102,23.7,38.1
        :01103,23.6,38.0
        :01104,23.7,38.0
        :01105,23.7,38.1
        :01106,23.6,38.0
        :01107,23.7,38.0
        :01108,23.7,38.0
        :01109,23.6,38.0
        :01110,23.7,38.0
    */  
}
