#include "mbed.h"
#include "HEPTA_CDH.h"
#include "HEPTA_EPS.h"
#include "HEPTA_SENSOR.h"
#include "HEPTA_COM.h"
HEPTA_CDH cdh(p5, p6, p7, p8, "sd");
HEPTA_EPS eps(p16,p26);
HEPTA_SENSOR sensor(p17,
                    p28,p27,0xD0,0x18,
                    p13,p14,p25,p24);
HEPTA_COM com(p9,p10);
DigitalOut condition(LED1);
Serial sat(USBTX,USBRX,9600);
Timer sattime;
int rcmd = 0,cmdflag = 0; //command variable

int main()
{
    sat.printf("From Sat : Nominal Operation\r\n");
    com.printf("From Sat : Nominal Operation\r\n");
    com.baud(9600);
    int flag = 0; //condition flag
    float batvol, temp; //voltage, temperature
    int rcmd=0,cmdflag=0;  //command variable
    sattime.start();
    eps.turn_on_regulator();//turn on 3.3V conveter

    while(1) {
        com.xbee_receive(&rcmd,&cmdflag);//interupting by ground station command
        //senssing HK data(dummy data)
        eps.vol(&batvol);
        sensor.temp_sense(&temp);
        wait_ms(100);
        //Transmitting HK data to Ground Station(GS)
        sensor.gps_setting();
        int quality=0,stnum=0,gps_check=0;
        char ns='A',ew='B',aunit='m';
        float time=0.0,latitude=0.0,longitude=0.0,hacu=0.0,altitude=0.0;
        com.printf("HEPTASAT::Condition=%d,Time=%f[s],batVol=%.2f[V],Temp=%.2f[C],GPGGA,%f,%f,%f\r\n",
                   flag,sattime.read(),batvol,temp,latitude,longitude,altitude);
        wait_ms(1000);

        //Power Saving Mode
        if((batvol <= 3.5)  | (temp > 35.0)) {
            eps.shut_down_regulator();
            com.printf("Power saving mode ON\r\n");
            flag = 1;
        } else if((flag == 1) & (batvol > 3.7) & (temp <= 25.0)) {
            eps.turn_on_regulator();
            com.printf("Power saving mode OFF\r\n");
            flag = 0;
        }
        //Contents of command
        //if (cmdflag == 1) {
        if (rcmd == '0') {
            sat.printf("rcmd=%c,cmdflag=%d\r\n",rcmd,cmdflag);
            com.printf("Hepta-Sat Uplink Ok\r\n");
            for(int j=0; j<5; j++) {
                com.printf("Hello World!\r\n");
                condition = 1;
                wait_ms(1000);
            }
        } else if (rcmd == '1') {
            sat.printf("rcmd=%c,cmdflag=%d\r\n",rcmd,cmdflag);
            com.printf("Hepta-Sat Uplink Ok\r\n");
            char str[100];
            mkdir("/sd/mydir", 0777);
            FILE *fp = fopen("/sd/mydir/satdata.txt","w");
            if(fp == NULL) {
                error("Could not open file for write\r\n");
            }
            for(int i = 0; i < 10; i++) {
                eps.vol(&batvol);
                fprintf(fp,"%f\r\n",batvol);
                condition = 1;
                wait_ms(1000);
            }
            fclose(fp);
            fp = fopen("/sd/mydir/satdata.txt","r");
            for(int i = 0; i < 10; i++) {
                fgets(str,100,fp);
                com.puts(str);
            }
            fclose(fp);
        } else if (rcmd == '2') {
            sat.printf("rcmd=%c,cmdflag=%d\r\n",rcmd,cmdflag);
            com.printf("Hepta-Sat Uplink Ok\r\n");
            sensor.gps_setting();
            int quality=0,stnum=0,gps_check=0;
            char ns='A',ew='B',aunit='m';
            float time=0.0,latitude=0.0,longitude=0.0,hacu=0.0,altitude=0.0;
            for(int i=1; i<1000; i++) {
                sensor.gga_sensing(&time, &latitude, &ns, &longitude, &ew, &quality, &stnum, &hacu, &altitude, &aunit, &gps_check);
                if((gps_check==0)|(gps_check==1)) {
                    com.printf("GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f,%c\r\n",time,latitude,ns,longitude,ew,quality,stnum,hacu,altitude,aunit);
                }
            }
        } else if (rcmd == '3') {
            sat.printf("rcmd=%c,cmdflag=%d\r\n",rcmd,cmdflag);
            com.printf("Hepta-Sat Uplink Ok\r\n");
            float ax,ay,az;
            com.printf("Accel Sensor Mode\r\n");
            for(int i = 0; i<50; i++) {
                sensor.sen_acc(&ax,&ay,&az);
                com.printf("%f,%f,%f\r\n",ax,ay,az);
                wait(0.5);
            }
        } else if (rcmd == '4') {
            sat.printf("rcmd=%c,cmdflag=%d\r\n",rcmd,cmdflag);
            com.printf("Hepta-Sat Uplink Ok\r\n");
            float gx,gy,gz;
            com.printf("Gyro Sensor Mode\r\n");
            for(int i = 0; i<50; i++) {
                sensor.sen_gyro(&gx,&gy,&gz);
                com.printf("%f,%f,%f\r\n",gx,gy,gz);
                wait(0.5);
            }
        } else if (rcmd == '5') {
            sat.printf("rcmd=%c,cmdflag=%d\r\n",rcmd,cmdflag);
            com.printf("Hepta-Sat Uplink Ok\r\n");
            float mx,my,mz;
            com.printf("Magnetometer Mode\r\n");
            for(int i = 0; i<50; i++) {
                sensor.sen_mag(&mx,&my,&mz);
                com.printf("%f,%f,%f\r\n",mx,my,mz);
                wait(0.5);
            }
        } else if (rcmd == '6') {
            sat.printf("rcmd=%c,cmdflag=%d\r\n",rcmd,cmdflag);
            com.printf("Hepta-Sat Uplink Ok\r\n");
            float ax,ay,az;
            float gx,gy,gz;
            float mx,my,mz;
            com.printf("9-axis sensor Mode\r\n");
            for(int i = 0; i<50; i++) {
                sensor.sen_acc(&ax,&ay,&az);
                sensor.sen_gyro(&gx,&gy,&gz);
                sensor.sen_mag(&mx,&my,&mz);
                com.printf("-,-,-,-,-,-,-,-,-,-,-,-,-,-,-,%f,%f,%f,%f,%f,%f,%f,%f,%f\r\n",ax,ay,az,gx,gy,gz,mx,my,mz);
                wait(0.5);
            }
        } else if (rcmd == '7') {
            sat.printf("rcmd=%c,cmdflag=%d\r\n",rcmd,cmdflag);
            com.printf("Hepta-Sat Uplink Ok\r\n");
            com.printf("CAMERA\r\n");
            sensor.Sync();
            sensor.initialize(HeptaCamera_GPS::Baud115200, HeptaCamera_GPS::JpegResolution320x240);
            sensor.test_jpeg_snapshot_data("/sd/test.txt");
            FILE *fp = fopen("/sd/test.txt", "r");
            if(fp == NULL) {
                sat.printf("Could not open file for write\r\n");
            } else {
                char str[1024];
                com.printf("INICIO\r\n");
                while((fgets(str,256,fp))!=NULL) {
                    com.printf("%s",str);
                    wait(0.001);
                }
                com.printf("FIN\r\n");
                //com.printf("Data transmitting finished:)\r\n");
                fclose(fp);
            }
        } else if (rcmd == '8') {
            com.initialize();
            sattime.stop();
            sat.printf("From Sat : End of operation\r\n");
            com.printf("From Sat : End of operation\r\n");
            break;
        }
        //}
    }
}