#include "HeptaGPS.h"
#include "mbed.h"

HeptaGPS::HeptaGPS(PinName tx, PinName rx) : gps(tx,rx)
{
}
void HeptaGPS::baud(int rate)
{
    gps.baud(rate);
}
char HeptaGPS::getc()
{
    c = gps.getc();
    return c;
}
int HeptaGPS::readable()
{
    i = gps.readable();
    return i;
}
void HeptaGPS::flushSerialBuffer(void)
{
    ite = 0;
    while (gps.readable())
    { 
        gps.getc();
        ite++;
        if(ite==100){break;};
    }
    return;
}
void HeptaGPS::gga_sensing(float *time, float *latitude, char *ns, float *longitude, char *ew, int *quality, int *stnum, float *hacu, float *altitude, char *aunit, int *gps_check)
{
    int ite = 0;
    while(gps.getc()!='$'){
        ite++;
        if(ite==10000) break;
    }
    for(int i=0; i<5; i++){
        msg[i] = gps.getc();
    }
    if((msg[2]=='G')&(msg[3]=='G')&(msg[4]=='A')){
        for(int j=0; j<6; j++){
            if(j==0){
                for(int i=5; i<256; i++){
                    msg[i] = gps.getc();
                    if(msg[i] == '\r') {
                        msg[i] = 0;
                        break;
                    }
                }
            }else{
                for(int i=0; i<256; i++){
                    msgd[i] = gps.getc();
                    if(msgd[i] == '\r') {
                        break;
                    }
                }
                if((msgd[4]=='V')&(msgd[5]=='T')&(msgd[6]=='G')){
                    break;
                }
            }
        }
        if(sscanf(msg, "GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f,%c", time, latitude, ns, longitude, ew, quality, stnum, hacu, altitude, aunit) >= 1) { 
            if(!(quality)) {
                //latitude(unit transformation)
                *latitude=int(*latitude/100)+(*latitude-int(*latitude/100)*100)/60;
                //longitude(unit transformation)
                *longitude = int(*longitude/100)+(*longitude-int(*longitude/100)*100)/60;
                *gps_check = 0;
            } else {
                //latitude(unit transformation)
                *latitude=int(*latitude/100)+(*latitude-int(*latitude/100)*100)/60;
                //longitude(unit transformation)
                *longitude = int(*longitude/100)+(*longitude-int(*longitude/100)*100)/60;
                *gps_check = 1;
            }
        }
        else{
            printf("No Data");
            *gps_check = 2;
        }       
    }
    else{
        *gps_check = 3;
    }
}
void HeptaGPS::lat_log_sensing_u16(char *lat, char *log, int *dsize)
{
    char gph1[8]={0x00},gph2[8]={0x00},gph3[8]={0x00},gph4[8]={0x00},gpt1[8]={0x00},gpt2[8]={0x00},gpt3[8]={0x00},gpt4[8]={0x00};
    int i=0,j=0;
    while (gps.readable()){ 
        gps.getc();
    }
    loop:
    while(gps.getc()!='$'){}
    for(j=0;j<5;j++){
        gps_data[1][j]=gps.getc();
    }
    if((gps_data[1][2]==0x52)&(gps_data[1][3]==0x4d)&(gps_data[1][4]==0x43)){
        for(j=0;j<1;j++){
            if(j==0){
                i=0;
                while((gps_data[j+1][i+5] = gps.getc()) != '\r'){    
                    //pc.putc(gps_data[j+1][i+5]);
                    i++;
                }
                gps_data[j+1][i+5]='\0';
                i=0;
                //pc.printf("\n\r");
            }
            else{
                while(gps.getc()!='$'){}
                i=0;
                while((gps_data[j+1][i] = gps.getc()) != '\r'){    
                    //pc.putc(gps_data[j+1][i]);
                    i++;
                }
                gps_data[j+1][i]='\0';
                i=0;
                //pc.printf("\n\r");
            }
        }
    }
    else
    {
        goto loop;
    }
    if( sscanf(gps_data[1],"GPRMC,%f,%c,%f,%c,%f,%c,%f",&time,&statas,&hokui,&ns,&tokei,&ew,&vel) >= 1){
        //hokui
        d_hokui=int(hokui/100);
        m_hokui=(hokui-d_hokui*100);
        //m_hokui=(hokui-d_hokui*100)/60;
        g_hokui=d_hokui+(hokui-d_hokui*100)/60;
        sprintf( gph1, "%02X", (char(d_hokui)) & 0xFF);
        sprintf( gph2, "%02X", (char(m_hokui)) & 0xFF);
        sprintf( gph3, "%02X", (char((m_hokui-char(m_hokui))*100)) & 0xFF);
        sprintf( gph4, "%02X", (char(((m_hokui-char(m_hokui))*100-char((m_hokui-char(m_hokui))*100))*100)) & 0xFF);
    
        //tokei
        d_tokei=int(tokei/100);
        m_tokei=(tokei-d_tokei*100);
        //m_tokei=(tokei-d_tokei*100)/60;
        g_tokei=d_tokei+(tokei-d_tokei*100)/60;
        sprintf( gpt1, "%02X", (char(d_tokei)) & 0xFF);
        sprintf( gpt2, "%02X", (char(m_tokei)) & 0xFF);
        sprintf( gpt3, "%02X", (char((m_tokei-char(m_tokei))*100)) & 0xFF);
        sprintf( gpt4, "%02X", (char(((m_tokei-char(m_tokei))*100-char((m_tokei-char(m_tokei))*100))*100)) & 0xFF);
        lat[0] = gph1[0];
        lat[1] = gph1[1];
        lat[2] = gph2[0];
        lat[3] = gph2[1];
        lat[4] = gph3[0];
        lat[5] = gph3[1];
        lat[6] = gph4[0];
        lat[7] = gph4[1];
        log[0] = gpt1[0];
        log[1] = gpt1[1];
        log[2] = gpt2[0];
        log[3] = gpt2[1];
        log[4] = gpt3[0];
        log[5] = gpt3[1];
        log[6] = gpt4[0];
        log[7] = gpt4[1];               
    }
    *dsize = 8;
}