#include "HeptaBattery.h"
#include "mbed.h"

HeptaBattery::HeptaBattery(PinName bat, PinName bat_ct, PinName reg_st) : _bat(bat),_bat_ct(bat_ct),_reg_st(reg_st)
{
    _bat_ct = 0;    // disable battery charge
    _reg_st = 1;    // able 3.3V regulator out
    PHY_PowerDown();// disable Ethernet connection
}
void HeptaBattery::vol(float* bt)
{
    *bt = (_bat.read()*1.431*3.3);
}
void HeptaBattery::vol_u16(char* bt_u16, int *dsize)
{
    unsigned short bt_datas;
    char bt1[8]={0x00},bt2[8]={0x00};
    bt_datas=_bat.read_u16()>>4;
    sprintf( bt1, "%02X", (bt_datas >> 8) & 0x0F);
    sprintf( bt2, "%02X", (bt_datas) & 0xFF);
    bt_u16[0]=bt1[0]; bt_u16[1]=bt1[1];
    bt_u16[2]=bt2[0]; bt_u16[3]=bt2[1];
    *dsize = 4;
}
void HeptaBattery::chargecontrol(int state, int *save_flag)
{
    float Bat;
    switch(state){
        case 1:
            //Battery Voltage High Level
            Peripheral_PowerUp(0xFDFF6FF7);
            _bat_ct = 0;
            _reg_st = 1;
            *save_flag = 0;
            break;
        case 2:
            //Battery Voltage Normal Level
            Peripheral_PowerUp(0xFDFF6FF7);
            _reg_st = 1;
            _bat_ct = 1;
            *save_flag = 0;
            break;
        case 3:
            //Battery Voltage Low Level
            Peripheral_PowerDown(0x7D7E6DF1);
            _bat_ct = 1;
            _reg_st = 0;
            *save_flag = 1;
            break;
        case 4:
            //Battery Voltage Auto Charge
            Bat = _bat.read()*1.431*3.3;
            if(Bat>=4.2){
                Peripheral_PowerUp(0xFDFF6FF7);
                printf("voltage high level = %f\r\n",Bat);
                printf("Complete!!!");
                _bat_ct = 0;
                _reg_st = 1;
                *save_flag = 0;
            }
            Peripheral_PowerDown(0x7D7E6DF1);
            printf("voltage low level = %f\r\n",Bat);
            _bat_ct = 1;
            _reg_st = 0;
            *save_flag = 1;
            break;
        default:
            printf("error\r\n");
            break;
    }
}

