#include "mbed.h"
#include "HeptaXbee.h"
#include "HeptaAccel.h"
#include "HeptaBattery.h"

Serial pc(USBTX,USBRX);
HeptaXbee xbee(p9, p10);//(tx,rx)=(Din,Dout)
HeptaBattery battery(p16,p29,p26);
HeptaAccel accel(p28,p27,0x38);

int main() {
    pc.baud(9600);
    xbee.baud(9600);
    xbee.printf("Xbee Uplink Ok Mode\r\n");
    int rcmd=0,cmdflag=0;
    char acx[4],acy[4],acz[4],bat[4];
    for(int i=1;i<10;i++){
        xbee.printf("num = %d\r\n",i);
        xbee.xbee_recieve(&rcmd,&cmdflag);
        pc.printf("rcmd=%d,cmdflag=%d\r\n",rcmd,cmdflag);
        if(cmdflag==1){
            if(rcmd=='a'){
               xbee.printf("Command Get\r\n");
               for(int j=1;j<10;j++){
                  accel.sensing_u16(acx,acy,acz);
                  battery.vol_u16(bat,&dsize[1]);
                  xbee.xbee_s_transmit(acx,acy,acz,bat);
                  wait(1.0);
               }
            }
        xbee.initialize();
        }
    wait (1.0);
     }
}