#include "HeptaGPS.h"
#include "mbed.h"

HeptaGPS::HeptaGPS(PinName tx, PinName rx) : gps(tx,rx)
{
}

void HeptaGPS::flushSerialBuffer(void)
{
    while (gps.readable())
    { 
        gps.getc();
    }
    return;
}

void HeptaGPS::sensing_u16(char* lad,char* log, int *dsize)
{
    char gph1[8]={0x00},gph2[8]={0x00},gph3[8]={0x00},gph4[8]={0x00},gpt1[8]={0x00},gpt2[8]={0x00},gpt3[8]={0x00},gpt4[8]={0x00};
    int i=0,j=0;
    while (gps.readable()){ 
        gps.getc();
    }
    loop:
    while(gps.getc()!='$'){}
    for(j=0;j<5;j++){
        gps_data[1][j]=gps.getc();
    }
    if((gps_data[1][2]==0x52)&(gps_data[1][3]==0x4d)&(gps_data[1][4]==0x43)){
        for(j=0;j<1;j++){
            if(j==0){
                i=0;
                while((gps_data[j+1][i+5] = gps.getc()) != '\r'){    
                    //pc.putc(gps_data[j+1][i+5]);
                    i++;
                }
                gps_data[j+1][i+5]='\0';
                i=0;
                //pc.printf("\n\r");
            }
            else{
                while(gps.getc()!='$'){}
                i=0;
                while((gps_data[j+1][i] = gps.getc()) != '\r'){    
                    //pc.putc(gps_data[j+1][i]);
                    i++;
                }
                gps_data[j+1][i]='\0';
                i=0;
                //pc.printf("\n\r");
            }
        }
    }
    else
    {
        goto loop;
    }
    if( sscanf(gps_data[1],"GPRMC,%f,%c,%f,%c,%f,%c,%f",&time,&statas,&hokui,&ns,&tokei,&ew,&vel) >= 1){
        //hokui
        d_hokui=int(hokui/100);
        m_hokui=(hokui-d_hokui*100);
        //m_hokui=(hokui-d_hokui*100)/60;
        g_hokui=d_hokui+(hokui-d_hokui*100)/60;
        sprintf( gph1, "%02X", (char(d_hokui)) & 0xFF);
        sprintf( gph2, "%02X", (char(m_hokui)) & 0xFF);
        sprintf( gph3, "%02X", (char((m_hokui-char(m_hokui))*100)) & 0xFF);
        sprintf( gph4, "%02X", (char(((m_hokui-char(m_hokui))*100-char((m_hokui-char(m_hokui))*100))*100)) & 0xFF);
    
        //tokei
        d_tokei=int(tokei/100);
        m_tokei=(tokei-d_tokei*100);
        //m_tokei=(tokei-d_tokei*100)/60;
        g_tokei=d_tokei+(tokei-d_tokei*100)/60;
        sprintf( gpt1, "%02X", (char(d_tokei)) & 0xFF);
        sprintf( gpt2, "%02X", (char(m_tokei)) & 0xFF);
        sprintf( gpt3, "%02X", (char((m_tokei-char(m_tokei))*100)) & 0xFF);
        sprintf( gpt4, "%02X", (char(((m_tokei-char(m_tokei))*100-char((m_tokei-char(m_tokei))*100))*100)) & 0xFF);
        lad[0] = gph1[0];
        lad[1] = gph1[1];
        lad[2] = gph2[0];
        lad[3] = gph2[1];
        lad[4] = gph3[0];
        lad[5] = gph3[1];
        lad[6] = gph4[0];
        lad[7] = gph4[1];
        log[0] = gpt1[0];
        log[1] = gpt1[1];
        log[2] = gpt2[0];
        log[3] = gpt2[1];
        log[4] = gpt3[0];
        log[5] = gpt3[1];
        log[6] = gpt4[0];
        log[7] = gpt4[1];               
    }
    *dsize = 8;
}
    
void HeptaGPS::sensing(float* lat, float* log )
{
    int i=0,j=0;
    while (gps.readable())
    { 
        gps.getc();
    }
    loop:
    while(gps.getc()!='$'){}
    for(j=0;j<5;j++)
    {
        gps_data[1][j]=gps.getc();
    }
    if((gps_data[1][2]==0x52)&(gps_data[1][3]==0x4d)&(gps_data[1][4]==0x43))
    {
        for(j=0;j<1;j++){
            if(j==0){
                i=0;
                while((gps_data[j+1][i+5] = gps.getc()) != '\r'){    
                    //pc.putc(gps_data[j+1][i+5]);
                    i++;
                }
                gps_data[j+1][i+5]='\0';
                i=0;
                //pc.printf("\n\r");
            }
            else{
                while(gps.getc()!='$'){}
                i=0;
                while((gps_data[j+1][i] = gps.getc()) != '\r'){    
                    //pc.putc(gps_data[j+1][i]);
                    i++;
                }
                gps_data[j+1][i]='\0';
                i=0;
                //pc.printf("\n\r");
            }
        }
    }
    else{
    goto loop;
    }
    if( sscanf(gps_data[1],"GPRMC,%f,%c,%f,%c,%f,%c,%f",&time,&statas,&hokui,&ns,&tokei,&ew,&vel) >= 1){
        //hokui
        d_hokui=int(hokui/100);
        m_hokui=(hokui-d_hokui*100);
        //m_hokui=(hokui-d_hokui*100)/60;
        *lat=d_hokui+(hokui-d_hokui*100)/60;
        //tokei
        d_tokei=int(tokei/100);
        m_tokei=(tokei-d_tokei*100);
        //m_tokei=(tokei-d_tokei*100)/60;
        *log = d_tokei+(tokei-d_tokei*100)/60;
        //pc.printf("Lat:%4.6f,Log:%4.6f\n\r",g_hokui,g_tokei);
    }
}