#include "mbed.h"
#include "BLE.h"
#include "XNucleoIKS01A2.h"

#if 1 //1:シリアルモニタ表示, 0:非表示
Serial pc(USBTX, USBRX);
#define DEBUG(...) { pc.printf(__VA_ARGS__); }
#else
#define DEBUG(...)
#endif

/* Instantiate the expansion board */
static XNucleoIKS01A2 *mems_expansion_board = XNucleoIKS01A2::instance(D14, D15, D4, D5);
static HTS221Sensor *hum_temp = mems_expansion_board->ht_sensor;

float value1, value2;

DigitalOut led(LED1);
Ticker ticker;
BLE ble;
const static char DEVICE_NAME[] = "CD1";
static Gap::ConnectionParams_t connectionParams;
uint16_t uuid_list[] = {GattService::UUID_DEVICE_INFORMATION_SERVICE};
uint8_t msg = 0;
uint16_t msg16 = 0;
uint8_t msg_low = 0;
uint8_t msg_high = 0;
uint8_t error_flag = 0;

//ここからサービスとキャラクタリスティックの用意
static const uint8_t UUID_CHAR_DATA[] = {0xFF,0xCF,0xFC,0xCC,0xFF,0xCF,0xFC,0xCC,0xFF,0xCF,0xFC,0xCC,0xFF,0xCF,0xFC,0xCC};//なんでもいい
GattCharacteristic customCharastic(UUID_CHAR_DATA, (uint8_t *)&msg16, sizeof(msg16), sizeof(msg16), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
GattCharacteristic *customChars[] = {&customCharastic};
GattService customService(GattService::UUID_DEVICE_INFORMATION_SERVICE, customChars, sizeof(customChars) / sizeof(GattCharacteristic *));

//BLE接続したら呼ばれるやつ
void connectionCallback(const Gap::ConnectionCallbackParams_t *params) {
    DEBUG("Connected!\n\r");
    ble.getPreferredConnectionParams(&connectionParams);
    connectionParams.minConnectionInterval = 7.5;
    connectionParams.maxConnectionInterval = 10;
    connectionParams.slaveLatency = 0;
    if (ble.gap().updateConnectionParams(params->handle, &connectionParams) != BLE_ERROR_NONE) {
        DEBUG("Failed to update\n\r");
    }
}

//BLE切断したら呼ばれるやつ
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params) {
    DEBUG("Disconnected!\n\r");
    ticker.detach();
    ble.gap().startAdvertising();
}

//周期的に呼ばれるやつ
void tickerCallback() {
    DEBUG("update\n\r");
    hum_temp->get_temperature(&value1);
    msg_high = (uint8_t)value1;
    msg_low = (uint8_t) ((value1 - msg_high) *255);
    msg16 = msg_high << 8 | msg_low ;
    DEBUG("msg = 0x%x\n\r", msg16);
    error_flag = ble.updateCharacteristicValue(customCharastic.getValueAttribute().getHandle(), (uint8_t *)&msg16 , sizeof(msg16));
    DEBUG("error = %d\n\r", error_flag);
}

//通知を開始するやつ
void updatesEnabledCallback(Gap::Handle_t handle) {
    led = 1;
    ticker.attach(&tickerCallback, 10);
    DEBUG("Notification is enabled\n\r");
}

//通知を停止するやつ
void updatesDisabledCallback(Gap::Handle_t handle) {
    led = 0;
    ticker.detach();
    DEBUG("Notification is disabled\n\r");
}

void printMacAddress()
{
    /* Print out device MAC address to the console*/
    Gap::AddressType_t addr_type;
    Gap::Address_t address;
    BLE::Instance().gap().getAddress(&addr_type, address);
    printf("DEVICE MAC ADDRESS: ");
    for (int i = 5; i >= 1; i--){
        printf("%02x:", address[i]);
    }
    printf("%02x\r\n", address[0]);
}


int main(void) {
    uint8_t id;
    
    DEBUG("start\n\r");
    
    hum_temp->enable();
    hum_temp->read_id(&id);
    printf("HTS221  humidity & temperature    = 0x%X\r\n", id);
    DEBUG("Initialize\n\r");
    ble.init();

    DEBUG("Setup the event handlers\n\r");
    ble.gap().onConnection(connectionCallback);
    ble.gap().onDisconnection(disconnectionCallback);
    ble.onUpdatesEnabled(updatesEnabledCallback);
    ble.onUpdatesDisabled(updatesDisabledCallback);

    DEBUG("Advertising payload\n\r");
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid_list, sizeof(uuid_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof((const uint8_t *)DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(160); //100ms;
    ble.gap().startAdvertising();

    DEBUG("Add service\n\r");
    ble.gattServer().addService(customService);

    printMacAddress();

    while (true) {
        ble.waitForEvent();
    }
}