#include "mbed.h"
#include "LEDS.h"

//Drive the rev LEDs

//Initialise PWM pins
LEDS::LEDS(PwmOut _pins[])
{
    pins = _pins;    
    
    pins[0].period_us(100);
}

//Calculate new PWM values
void LEDS::refresh(float rpm)
{
    int value;
    int remainder;
    int i;
    
    //Number of fully-lit LEDs
    value = rpm / RESOLUTION;
  
    for(i = 0; i < NUM_LEDS; i++)
    {          
        if(i < value)
        {   
            //First LEDs on
            pins[i] = 1.0;
        }
        else if(i == value)
        {
            //Last LED partially lit - calculate intensity and set.
            remainder = (int)rpm % RESOLUTION;
            pins[i] = (float)remainder / (float)RESOLUTION;
        }
        else
        {
            //All others off
            pins[i] = 0.0;
        }
    }
}