#include "PCComms.h"
#include "mbed.h"
#include "State.h"

//Process incoming data from Comms interfaces

//Initialise members
Comms::Comms(State* _values)
{
    values = _values;
}

//Process an incoming data packet
void Comms::process_packet(unsigned char id, int length, unsigned char data[])
{
    switch(id)
    {
        case 100:
            values->rpm = data[0] + (data[1] << 8);
            values->throttle_pos = data[2];
            values->manifold_pres = data[3];
            values->air_temp = data[4];
            values->coolant_temp = data[5];
            values->lambda = data[6];
            break;
        case 200:
            values->speed = data[0];
            values->accel_x = data[1];
            values->accel_y = data[2];
            values->gear = data[3];
            values->oil_temp = data[4];
            values->oil_pres = data[5];
            values->warnings = data[6];
            break;
    }
}