#ifndef FBRDASH_LEDS_H
#define FBRDASH_LEDS_H

#include "mbed.h"

class LEDS
{
    public:
        LEDS(PwmOut _pins[]);
        void refresh(float rpm);
        
        static const int NUM_LEDS = 6;
    
    private:
        PwmOut* pins;
    
    //revs represented by last red LED
    static const int LIMIT = 18000.0;
    
    //number of revs per LED
    static const int RESOLUTION = LIMIT / NUM_LEDS;
        
};

#endif