#include "PCComms.h"
#include "mbed.h"
#include "State.h"

#define BUFFER_LENGTH   10

PCComms::PCComms(State* _values) : Comms(_values)
{
    pc = new Serial(USBTX, USBRX);
    
    pc->attach(this, &PCComms::receive, Serial::RxIrq);
}

void PCComms::send(char message)
{
    pc->putc(message);
}

void PCComms::receive()
{    
    unsigned char packet_id;
    unsigned char data_length;
    
    unsigned char buffer[BUFFER_LENGTH];
    
    int i;
    
    if(pc->readable())
    {
        if(pc->getc() == 0xFF && pc->getc() == 0xFF) //Handshake(ish)
        {
            packet_id = pc->getc();
            data_length = pc->getc();
            
            for(i = 0; i < data_length && i < BUFFER_LENGTH; i++)
            {
                buffer[i] = pc->getc();
            }
            
            process_packet(packet_id, data_length, buffer);
        }
    }
}