#include "mbed.h"
#include "LEDS.h"

//Drive the rev LEDs

//Initialise PWM pins
LEDS::LEDS(PwmOut _pins[])
{
    pins = _pins;    
    
    pins[0].period_us(100);
}

//Calculate new PWM values
void LEDS::refresh(float rpm)
{
    
    //Engine running
    pins[0]=(rpm-1000)/4000;
    //Change Down
    pins[1]=(rpm-5000)/2000;
    //Good gear
    pins[2]=(rpm-7000)/2000;
    pins[3]=(rpm-9000)/2000;
    //Change up
    pins[4]=(rpm-11000)/500;
    //Change up urgently
    pins[5]=(rpm-11500)/500;
}