#include "TextLCD.h"
#include "bigchar.h"

//Set up character memory on LCD for drawing two line numbers
void setup_bigchar(TextLCD* lcd)
{
    int top_left[8] = {0x07, 0x0F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, };
    lcd->writeCGRAM(TOP_LEFT, top_left);
    
    int top_right[8] = {0x1C, 0x1E, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, };
    lcd->writeCGRAM(TOP_RIGHT, top_right);
    
    int bottom_right[8] = {0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1E, 0x1C, };
    lcd->writeCGRAM(BOTTOM_RIGHT, bottom_right);
    
    int bottom_left[8] = {0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x0F, 0x07, };
    lcd->writeCGRAM(BOTTOM_LEFT, bottom_left);
    
    int two_lines[8] = {0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x1F, 0x1F, };
    lcd->writeCGRAM(TWO_LINES, two_lines);
    
    int bottom[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x1F, };
    lcd->writeCGRAM(BOTTOM, bottom);
    
    int top[8] = {0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, };
    lcd->writeCGRAM(TOP, top);
    
    int two_lines_5[8] = {0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x1E, 0x1F, };
    lcd->writeCGRAM(TWO_LINES_5, two_lines_5);
}

//Draw two-line numbers
void write_bigchar(TextLCD* lcd, int position, int number)
{
    switch(number)
    {
        case 0:
            lcd->locate(position, 0);
            lcd->putc(TOP_LEFT);
            lcd->putc(TOP);
            lcd->putc(TOP_RIGHT);
            lcd->locate(position, 1);
            lcd->putc(BOTTOM_LEFT);
            lcd->putc(BOTTOM);
            lcd->putc(BOTTOM_RIGHT);
            break;
        case 1:
            lcd->locate(position, 0);
            lcd->putc(TOP);
            lcd->putc(TOP_RIGHT);
            lcd->putc(BLANK);
            lcd->locate(position, 1);
            lcd->putc(BOTTOM);
            lcd->putc(FULL);
            lcd->putc(BOTTOM);
            break;
        case 2:
            lcd->locate(position, 0);
            lcd->putc(TWO_LINES);
            lcd->putc(TWO_LINES);
            lcd->putc(TOP_RIGHT);
            lcd->locate(position, 1);
            lcd->putc(BOTTOM_LEFT);
            lcd->putc(BOTTOM);
            lcd->putc(BOTTOM);
            break;
        case 3:
            lcd->locate(position, 0);
            lcd->putc(TOP);
            lcd->putc(TWO_LINES);
            lcd->putc(TOP_RIGHT);
            lcd->locate(position, 1);
            lcd->putc(BOTTOM);
            lcd->putc(BOTTOM);
            lcd->putc(BOTTOM_RIGHT);
            break;
        case 4:
            lcd->locate(position, 0);
            lcd->putc(BOTTOM_LEFT);
            lcd->putc(BOTTOM);
            lcd->putc(FULL);
            lcd->locate(position, 1);
            lcd->putc(BLANK);
            lcd->putc(BLANK);
            lcd->putc(FULL);
            break;
        case 5:
            lcd->locate(position, 0);
            lcd->putc(FULL);
            lcd->putc(TWO_LINES);
            lcd->putc(TWO_LINES_5);
            lcd->locate(position, 1);
            lcd->putc(BOTTOM);
            lcd->putc(BOTTOM);
            lcd->putc(BOTTOM_RIGHT);
            break;
        case 6:
            lcd->locate(position, 0);
            lcd->putc(TOP_LEFT);
            lcd->putc(TWO_LINES);
            lcd->putc(TWO_LINES_5);
            lcd->locate(position, 1);
            lcd->putc(BOTTOM_LEFT);
            lcd->putc(BOTTOM);
            lcd->putc(BOTTOM_RIGHT);
            break;
        default:
            lcd->locate(position, 0);
            lcd->putc(BLANK);
            lcd->putc(BLANK);
            lcd->putc(BLANK);
            lcd->locate(position, 1);
            lcd->putc(BLANK);
            lcd->putc(BLANK);
            lcd->putc(BLANK);
            break;            
    }
}