#include "mbed.h"
#include "SCP1000.h"
#include "string"
#include "SDHCFileSystem.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled4(LED4);
Serial xbee(p9,p10);
SCP1000 scp1000(p11,p12,p13,p14);
SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sclk, cs
I2C i2c(p28, p27); // sda, scl

const int AQCM0802_addr = 0x7C;

unsigned char mode;
unsigned char contrast = 0; // 0-63
unsigned char contrastFlag = false;
int CGcounter;
int FADEcounter;

void lcd_cmd(char x) {
  char data[2];
  data[0] = 0x00; // CO = 0,RS = 0
  data[1] = x;
  i2c.write(AQCM0802_addr, data, 2);
}

void lcd_contdata(char x) {
  char data[2];
  data[0] = 0xC0; //0b11000000 CO = 1, RS = 1
  data[1] = x;
  i2c.write(AQCM0802_addr, data, 2);
}

void lcd_lastdata(char x) {
  char data[2];
  data[0] = 0x40; //0b11000000 CO = 0, RS = 1
  data[1] = x;
  i2c.write(AQCM0802_addr, data, 2);
}

void lcd_printStr(const char *s) {
  while(*s) {
    if(*(s + 1)) {
      lcd_contdata(*s);
    } else {
      lcd_lastdata(*s);
    }
    s++;
  }
}

void lcd_printHex(unsigned char num) {
  lcd_contdata(num);
}

void lcd_init() {
  wait(0.04);
  // LCD initialize
  lcd_cmd(0x38); // function set
  lcd_cmd(0x39); // function set
  lcd_cmd(0x04); // EntryModeSet
  lcd_cmd(0x14); // interval osc
  lcd_cmd(0x70 | (contrast & 0xF)); // contrast Low
  lcd_cmd(0x5C | ((contrast >> 4) & 0x3)); // contast High/icon/power
  lcd_cmd(0x6C); // follower control
  wait(0.2);
  lcd_cmd(0x38); // function set
  lcd_cmd(0x0C); // Display On
  lcd_cmd(0x01); // Clear Display
  wait(0.2); // need additional wait to Clear Display
}

void lcd_setCursor(unsigned char x,unsigned char y) {
  lcd_cmd(0x80 | (y * 0x40 + x));
}

unsigned char cg[13 * 8] = {
    
};

void setCG(int src,int dst,int len) {
  lcd_cmd(0x38);
  lcd_cmd(0x40 + dst);
  if (src >= 0) {
    for (int i = 0;i < len;i++) lcd_printHex(cg[src + i]);
  } else {
    for (int i = 0;i < len;i++) lcd_printHex(0);
  }
}

void setContrast(unsigned char c) {
  lcd_cmd(0x39);
  lcd_cmd(0x70 | (c & 0x0f)); // contrast Low
  lcd_cmd(0x5C | ((c >> 4) & 0x03)); // contast High/icon/power
  lcd_cmd(0x38);
}

//main start

int main() {
    char a;
    char c[256],g[256],u[256],d,sta[6],wake=0,res=1;
    int pre,j=0,i=0;
    unsigned long kiatu=0,pre2=0;
    float kiatusa=0,tmp2,high=0,gosa=0,goukei=0,goukei2=0,heikin=0,heikin2=0,den,vol;
    double high1=0,high0=0;
    long presa=0;
    
    
    lcd_init();
    setContrast(30);
    lcd_setCursor(0, 0);  
    lcd_printStr("pre");
    lcd_setCursor(0, 1);  
    lcd_printStr("TEST02");    
    
    while(1){
        
        if(xbee.readable()==0){   // serial in falt


        }
        
        if(xbee.readable()==1){  // serial in true
            
            //old program
            
            while(xbee.getc()!='$');   //form can-sat                 
            
            //d=xbee.getc();
            pre=0;
            
            while((c[pre]=xbee.getc())!='#'){
                printf("%c",c[pre]);
                pre++;
            }
            printf("\n");
            pre=0;
            while((g[pre]=xbee.getc())!='@'){
                printf("%c",g[pre]);
                pre++;
            }
            printf("\n");
            pre=0;            
            while((u[pre]=xbee.getc())!='\n'){
                printf("%c",u[pre]);
                pre++;
            }
            printf("\n");
                                                       
            //c[pre]='\0';
            
         /*   if(d=='p'){
                sscanf(c,"%d",&kiatu);                
                goukei=goukei+kiatu;
                goukei2=goukei2+pre2;           
                j++;       
            }
            
            printf("%d\n",j);  
                     
            if(d=='v'){
                sscanf(c,"%f",&den);
            }
            
            if(d=='m'){
                strcpy(sta,c);
                
            }
            
            vol=den*3.3+(den*3.3*2/3);
            
            //printf("%s  \n",sta);
            
            
            if(j==5){           
                heikin=goukei/5; 
                heikin2=goukei2/5;           
                high1=(heikin-gosa)/heikin2;
                high0=pow(high1,0.1902);
                high=153.8*(tmp2+273.2)*(1.0-high0);
                       
                printf("H=%lu\n",high);
                
                j=0;
                goukei=0;
                goukei2=0;         
               
            }*/
                       
            
            c[0]='\0';
            
        //if(sky.readable()==0){
            
       // }    

        }            
            
       /*     myled4=1;
            a=xbee.getc();
            printf("XBEE=%c\n",a);
            wait(0.2);
            myled4=0;
            wait(0.2);        
        } */
        
      /*  FILE *fp = fopen("/sd/pre.csv", "a");
        fprintf(fp,"%d\n",scp1000.readPressure());
        fclose(fp);*/

    }
}
