#include "mbed.h"

#define    TMP007_Voltage     0x00 
#define    TMP007_LocalTemp   0x01
#define    TMP007_Conf        0x02
#define    TMP007_ObjTemp     0x03

#define    TMP007_ADDR 0x80
 
I2C i2c(PA_10, PA_9);
 
//DigitalOut myled(LED1);
 
Serial pc(PA_2, PA_3);

int16_t temp_c, temp_c_2s, voltage_tot, voltage_h, voltage_2s, voltage_tot_a;
float celsius, farenheit, voltage;
char temp_write[3];
char temp_read[2];
uint8_t temp_h, temp_l, temp_h_and, voltage_l, voltage_h_and; 
int sign;

//char TMP007_ObjTemp = 0x03;

 
int main()
{
 

 
    /* Configure the Temp Sensor:

    */
    temp_write[0] = TMP007_Conf;
    temp_write[2] = 0x40;   //Mode On, Alert, TC, 16 samples
    temp_write[1] = 0x19;   //check order of these (endianness)
    i2c.write(TMP007_ADDR, temp_write, 3, 0);
    
    while (1) {
        // Read Temp Sensor
        
        //Tell the temp sensor to take a one shot temperature measurement
        //temp_write[0] = LM75B_Conf;
        //temp_write[1] = 0x50;   //One shot, low power mode
        //i2c.write(LM75B_ADDR, temp_write, 2, 0);
        
        //Read Temperature Register
        temp_write[0] = TMP007_ObjTemp;
        i2c.write(TMP007_ADDR, temp_write, 1, false); // no stop (unsure)
        i2c.read(TMP007_ADDR, temp_read, 2, 0);
        
        temp_h = temp_read[0];
        temp_l = temp_read[1];
        
        pc.printf("Object Temperature\n");
        pc.printf("high bit = %x\n", temp_h);
        pc.printf("low bit = %x\n", temp_l);
        
        temp_c = ((temp_h) << 8) | temp_l;
        
        //int tempval = (int)((int)data_read[0] << 8) | data_read[1];
        pc.printf("combined bit = %x\n", temp_c);
        temp_h_and = temp_h & 0x80;
        //check for negative number        
        if (temp_h_and == 0x80)
        {
            
            //flip bits and add 1
            temp_c_2s = temp_c ^ 0x7FFF + 0x04;
            //temp_c_shift  = ((temp_c_2s)>>2);
            celsius = ((float)temp_c_2s * -0.25f) *.03125f;
            pc.printf("negative\n");
            pc.printf("anded high bit = %x\n", temp_h_and);         
         }       
        else 
        {
            //temp_c_shift = ((temp_c)>>2);
            //pc.printf("shifted bits: %x\n", temp_c_shift);
            celsius = ((float)temp_c * 0.25f) *.03125f;
            pc.printf("positive\n");
        }
        pc.printf("Capsule Temperature is: %f C\n", celsius);    
        farenheit = 1.8*celsius + 32;
        pc.printf("Capsule Temperature is: %f F\n\n", farenheit);
        
        //Read Internal Temperature Register
        temp_write[0] = TMP007_LocalTemp;
        i2c.write(TMP007_ADDR, temp_write, 1, false); // no stop (unsure)
        i2c.read(TMP007_ADDR, temp_read, 2, 0);
        
        temp_h = temp_read[0];
        temp_l = temp_read[1];
        
        pc.printf("Internal Temperature\n");
        pc.printf("high bit = %x\n", temp_h);
        pc.printf("low bit = %x\n", temp_l);
        
        temp_c = ((temp_h) << 8) | temp_l;
        
        //int tempval = (int)((int)data_read[0] << 8) | data_read[1];
        pc.printf("combined bit = %x\n", temp_c);
        temp_h_and = temp_h & 0x80;
        //check for negative number        
        if (temp_h_and == 0x80)
        {
            
            //flip bits and add 1
            temp_c_2s = temp_c ^ 0x7FFF + 0x04;
            //temp_c_shift  = ((temp_c_2s)>>2);
            //scale
            celsius = ((float)temp_c_2s * -0.25f) *.03125f;
            pc.printf("negative\n");
            //pc.printf("anded high bit = %x\n", temp_h_and);         
         }       
        else 
        {
            //temp_c_shift = ((temp_c)>>2);
            //pc.printf("shifted bits: %x\n", temp_c_shift);
            //scale
            celsius = ((float)temp_c * 0.25f) *.03125f;
            pc.printf("positive\n");
        }
        pc.printf("Internal Temperature is: %f C\n", celsius);    
        farenheit = 1.8*celsius + 32;
        pc.printf("Internal Temperature is: %f F\n\n", farenheit);
        
        //Read Voltage Register
        temp_write[0] = TMP007_Voltage;
        i2c.write(TMP007_ADDR, temp_write, 1, false); // no stop (unsure)
        i2c.read(TMP007_ADDR, temp_read, 2, 0);
        
        voltage_h = temp_read[0];
        voltage_l = temp_read[1];
        
        pc.printf("Sensor Voltage\n");
        pc.printf("high bit = %x\n", voltage_h);
        pc.printf("low bit = %x\n", voltage_l);
        
        voltage_tot = ((voltage_h) << 8) | voltage_l;
        voltage_tot_a = voltage_tot & 0x0000FFFF;
        
        //int tempval = (int)((int)data_read[0] << 8) | data_read[1];
        pc.printf("combined bit = %x\n", voltage_tot_a);
        voltage_h_and = voltage_h & 0x80;
        //check for negative number        
        if (voltage_h_and == 0x80)
        {
            
            //flip bits and add 1
            //voltage_2s = voltage_tot ^ 0x7FFF + 0x01;
            voltage_2s = ~voltage_tot_a + 0x01;
            pc.printf("2's compliment conversion: %x\n", voltage_2s);
            //temp_c_shift  = ((temp_c_2s)>>2);
            voltage = ((float)voltage_2s * -1.0f) *.00015625f;
            pc.printf("negative\n");
            //pc.printf("anded high bit = %x\n", temp_h_and);         
         }       
        else 
        {
            //temp_c_shift = ((temp_c)>>2);
            //pc.printf("shifted bits: %x\n", temp_c_shift);
            voltage = ((float)voltage_tot_a * 1.0f) *.00015625f;
            pc.printf("positive\n");
        }
        pc.printf("Sensor Voltage is: %f mV\n\n\n", voltage);    
        
        
        
        
        wait(4);    
    }
}