//AccelerometerTest
//Toby Galal
//6 November 2015
//A program used to gather data from ADXL335 accelerometers and print them to file (.txt) in a MatLab-compliant format

#include "mbed.h"

//Hardware Initialisation
AnalogIn XIn(p15); //X Input
AnalogIn YIn(p16); //Y Input
AnalogIn ZIn(p17); //Z Input
Serial pc(USBTX, USBRX); //Serial to print readings to terminal
Ticker timer; //Timer to call ISR

//Global Variables
float X, Y, Z; //variables to store XYZ readings
float Xo, Yo, Zo; //variables to store 0G bias readings
int flag; //flag for ISR
float CalX[1000], CalY[1000], CalZ[1000]; //arrays to store calibration readings
int n = 0; //variable to store the number of readings

//Function Prototypes
void Calibrate();
void Send_Data();
void ISR();


//Main Function    
int main() {
    
    wait(2.0); //allow accelerometer to stabilise
    timer.attach(&Calibrate, 0.001); //attach Calibrate function to timer

    while (1) {
        if (flag) { //if flag has been set
            flag = 0; //reset flag
            Send_Data();
        }
    }
}

//Function Definitions
void Calibrate() {        
    CalX[n] = XIn.read() * 3.3; //read XYZ pins and store in array
    CalY[n] = YIn.read() * 3.3;
    CalZ[n] = ZIn.read() * 3.3;
    n++; //increment counter
    
    if (n == 1000) { //when enough samples have been taken
        timer.detach(); //detach timer from Calibrate()
        
        for (int i = 0; i < 1000; i++) { //sum sample readings
            Xo = Xo + CalX[i];
            Yo = Yo + CalY[i];
            Zo = Zo + CalZ[i];
        }

        Xo = Xo / 1000; //find mean and store it
        Yo = Yo / 1000;
        Zo = Zo / 1000;
        
        pc.printf("Calibration Values = %.3f | %.3f | %.3f\n\r", Xo, Yo, Zo); //debug
        timer.attach(&ISR, 0.001); //attach timer to ISR for real data collection
    }
}

void Send_Data() {
    X = ((XIn.read() * 3.3) - Xo) / 0.3; //read input, subtract zeroed value to find offset, and convert to g (300mv/g)
    Y = ((YIn.read() * 3.3) - Yo) / 0.3;
    Z = ((ZIn.read() * 3.3) - Zo) / 0.3;   
    pc.printf("%.3f %.3f %.3f",X, Y, Z); //print output to serial
}

void ISR() {
    flag = 1; //set flag
}
