#include <mbed.h>
#include "ACS712.h"
#include "ESP8266.h"
#include "TextLCD.h"
#define SSID "OnePlus3"
#define PASS "testingforidp"
#define IP "184.106.153.149"

Serial pc(USBTX, USBRX);
AnalogIn voltage(p20);
ESP8266 wifi(p28, p27, 115200); 
ACS712 dev(p18);
TextLCD lcd(p26, p25, p24, p23, p22, p21); // rs, e, d4-d7

float volt,currn,sample,Current,RMScurrn,power,ener,cumuEnergy;
float mess = 0;
char snd[255],resp[1000];
char http_cmd[300], comm[300];

char* Update_Key = "M2ZXTED1OM75Z9YU";
int timeout = 8000;
void send_Wifi();

int main()
{
    pc.baud(115200);
    // Connect the sensor analog output pin to mbed's AnalogIn pin
    
    
    pc.printf("******** Resetting wifi module ********\r\n");
    wifi.Reset();
    
    //wait for 5 seconds for response, else display no response receiveed
    if (wifi.RcvReply(resp, 5000))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response");
    
    pc.printf("******** Setting Station mode of wifi with AP ********\r\n");
    wifi.SetMode(1);    // set transparent  mode
    if (wifi.RcvReply(resp, timeout))    //receive a response from ESP
        pc.printf("%s",resp);    //Print the response onscreen
    else
        pc.printf("No response while setting mode. \r\n");
    
    pc.printf("******** Joining network with SSID and PASS ********\r\n");
    wifi.Join(SSID, PASS);     
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);   
    else
        pc.printf("No response while connecting to network \r\n");
    
    pc.printf("Sensor Log: \n\n\r");

    while (1) {
        
        volt = abs((voltage.read()-0.059)*30);
        pc.printf("Voltage: %.3f V\n\r",volt);
        lcd.printf("%.3fV   ",volt);

        // Read current from sensor and output to pc terminal
        Current = abs(float(dev))*2;
        pc.printf("Current: %2.3f A\n\r", Current);
        lcd.printf("%2.3fA", Current);
        
        power = abs(volt * Current);
        pc.printf("RMSPower: %.3f W\n\r",power);
        lcd.locate(0, 1);
        lcd.printf("%.3fW ",power);
        
        ener = power * 3600 / 1000;
        pc.printf("Energy: %.3f kWh\n\r",ener);
        cumuEnergy = cumuEnergy + ener;
        pc.printf("Total Energy: %.3f kWh\n\n\r",cumuEnergy);
        lcd.printf("%2.3fkWh", cumuEnergy);
        
        if (cumuEnergy > 30){
            pc.printf("*******POWER USAGE WARNING!********\n\r");
            send_Wifi();
        }
        wait(0.8);
        lcd.cls();
    }
}

void send_Wifi(){
    
    pc.printf("******** Setting WIFI UART passthrough ********\r\n");
    wifi.setTransparent();          
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while setting wifi passthrough. \r\n");
    wait(1);    
    
    pc.printf("******** Setting single connection mode ********\r\n");
    wifi.SetSingle();             
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while setting single connection \r\n");
    wait(1);
    pc.printf("******** Starting TCP connection on IP and port ********\r\n");
    wifi.startTCPConn(IP,80);    //cipstart
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while starting TCP connection \r\n");
    wait(1);
    
    //create link 
    mess = cumuEnergy;
    sprintf(http_cmd,"/update?api_key=%s&field1=%f",Update_Key,mess); 
    pc.printf(http_cmd);
    
    pc.printf("******** Sending URL to wifi ********\r\n");
    wifi.sendURL(http_cmd, comm);   //cipsend and get command
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
 
    pc.printf("No response while sending URL \r\n");
}
    