#ifndef STC3100Sensor_H_
#define STC3100Sensor_H_

/**
 * I2C Device address
 * ------------------
 * The mbed API uses 8 bit addresses, so make sure to thake the 7 bit address
 * and left shift it by 1 before passing it.
 * The eight bit presents a R/W bit, see datasheet STC3100 page 12.
 */
#define STC3100_ADDRESS_READ    0b11100000
#define STC3100_ADRESS_WRITE    0b11100001

/**
 * INTERNAL REGISTER MAP
 * ---------------------
 * For this application the RAM registers are not used
 */
#define REG_MODE                0   // Mode register                            (R/W)
#define REG_CTRL                1   // Control and status register              (R/W)
#define REG_CHARGE_LOW          2   // Gas gauge charge data,       bits 0-7    (R)
#define REG_CHARGE_HIGH         3   // Gas gauge charge data,       bits 8-15   (R)
#define REG_COUNTER_LOW         4   // Number of conversions,       bits 0-7    (R)
#define REG_COUNTER_HIGH        5   // Number of conversions,       bits 8-15   (R)
#define REG_CURRENT_LOW         6   // Battery current value,       bits 0-7    (R)
#define REG_CURRENT_HIGH        7   // Battery current value,       bits 8-15   (R)
#define REG_VOLTAGE_LOW         8   // Battery voltage value,       bits 0-7    (R)
#define REG_VOLTAGE_HIGH        9   // Battery voltage value,       bits 8-15   (R)
//#define REG_TEMPERATURE_LOW     10    // Temperature value,           bits 0-7    (R)
//#define REG_TEMPERATURE_HIGH    11    // Temperature value,           bits 8-15   (R)

//The following registers are the Device ID registers (R)
//#define REG_ID0                 24
//#define REG_ID1                 25
//#define REG_ID2                 26
//#define REG_ID3                 27
//#define REG_ID4                 28
//#define REG_ID5                 29
//#define REG_ID6                 30
//#define REG_ID7                 31

        unsigned char Mode;
        unsigned char ControlStatus;
        unsigned char ChargeLow;
        unsigned char ChargeHigh;
        unsigned char CounterLow;
        unsigned char CounterHigh;
        unsigned char CurrentLow;
        unsigned char CurrentHigh;
        unsigned char VoltageLow;
        unsigned char VoltageHigh;
//      unsigned char TemperatureLow;
//      unsigned char TemperatureHigh;
//      unsigned char Reserved[13];
//      unsigned char ID0;
//      unsigned char ID1;
//      unsigned char ID2;
//      unsigned char ID3;
//      unsigned char ID4;
//      unsigned char ID5;
//      unsigned char ID6;
//      unsigned char ID7;

/**
 * Struct that stores the updated values.
 */
    // Voltage in mV
    float voltage;
    // Current in mA
    float current;
    // Current charge of the battery mAh
    float charge;
//  // Temperature in °C
//  float temperature;

//STC3100ActualData stc3100ActualData;
//STC3100Data stc3100Data;
// Reading of the chip will be stored in the byteArray
char byteArray[10];

void stc3100Configure(void);
void stc3100ReadChip(void);
void updateData(void);
float getVoltage(void);
float getCurrent(void);
float getCharge(void);
//float getTemperature(void);

#endif /* STC3100Sensor_H_ */
