/**
 * Driver for the STC3100
 */
#include "mbed.h"
#include "STC3100Sensor.h"

I2C i2c(D14, D15);

/**
 * Configuring the STC3100
 * ------------------------
 * This is done for the user automatically. See datasheet STC3100 page 15 for the
 * configuration that is applied.
 */
void stc3100Configure(void) {

    //The user need to provide the first address of the register, an increment
    //will be done automatically.
    char writeData[3];
    //REG_MODE address
    writeData[0] = 0x00;
    //Configuration REG_MODE
    writeData[1] = 0x1c;
    //Configuration REG_CTRL
    writeData[2] = 0x03;

    i2c.write(STC3100_ADRESS_WRITE, writeData, 3);
}

/**
 * Reading the whole memory block (that is been declared) and save it to the byteArray
 * of the ustc3100Data union.
 */
void stc3100ReadChip(void) {

    i2c.read(STC3100_ADDRESS_READ, &(byteArray[0]), 10);
}

/**
 * Calculating of the data, they will be stored in the stc3100ActualData struct.
 */
void updateData(void) {

    unsigned int high_byte = 0;
    int value = 0;

    stc3100ReadChip();

    // Converting to voltage
    high_byte = (unsigned int) VoltageHigh;
    high_byte <<= 8;
    value = (high_byte & 0xFF00) | VoltageLow;
    voltage = (float) value * 2.44;

    // Converting to current
    high_byte = (unsigned int) CurrentHigh;
    high_byte <<= 8;
    value = (high_byte & 0xFF00) | CurrentLow;
    value <<= 2;
    current =
            ((((float) value * 11.77) / 10.0) / 4.0) > 0.0 ?
                    ((((float) value * 11.77) / 10.0) / 4.0) :
                    -((((float) value * 11.77) / 10.0) / 4.0);
    current -= 54.0;

    // Converting to charge
    high_byte = (unsigned int) ChargeHigh;
    high_byte <<= 8;
    value = (high_byte & 0xFF00) | ChargeLow;
    charge = ((float) value * 6.70) / 10.0;

    //  // Converting to temperature
    //  high_byte = (unsigned int) stc3100Data.TemperatureHigh;
    //  high_byte <<= 8;
    //  value = (high_byte & 0xFF00) | stc3100Data.TemperatureLow;
    //  value <<= 4;
    //  stc3100ActualData.temperature = ((float) value * 0.125) / 16.0;

}

/**
 * Method for returning the voltage
 */
float getVoltage(void) {
    return voltage;
}

/**
 * Method for returning the current
 */
float getCurrent(void) {
    return current;
}

/**
 * Method for returning the charge
 */
float getCharge(void) {
    return charge;
}
