#include "mbed.h"
#include "ov7670s.h"

OV7670 camera(
    D14, D15,       // SDA,SCL(I2C / SCCB)
    D9,D8,D10,   // VSYNC,HREF,pcclk
    D7,D6,D5,D4,D3,D2,D1,D0,
    A5) ; // RRST

Serial pc(USBTX,USBRX);

#define SIZEX (160)
#define SIZEY (120)
#define SIZE 19200

unsigned char bank0 [SIZE];
unsigned char *bank1 = (unsigned char *)(0x2007C000);

int main()
{



    
    camera.Reset() ;

    // Set up for 160*120 pixels RGB565
    camera.InitQQVGA() ;


    camera.CaptureNext() ;
    while (camera.CaptureDone() == false) ;

    while (!pc.readable()) {

        camera.ReadStart();

        for (int i = 0; i < SIZE; i++) {
            bank0[i] =  camera.ReadOneByte();
        }

        for (int i = 0; i < SIZE ; i++) {
            bank1[i] =  camera.ReadOneByte();
        }

        camera.ReadStop() ;

        camera.CaptureNext() ;


        while (camera.CaptureDone() == false) ;
    }
}
