#include "mbed.h"
#include "GPS.h"
#include "TextLCD.h"
#define BUFFER_SIZE 100

GPS gps(PA_11,PA_12);
I2C i2c_lcd(D14,D15); 
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2); 
Serial esp(D8,D2);
DigitalIn bt(D5,PullUp);
Serial pc(USBTX, USBRX);
char message[400];

uint8_t buffer[0x100];  
uint16_t buffer_head;  
uint16_t buffer_tail;  
char s1[100];


void rxcallback(void) {  
    uint8_t chr;  
    while (esp.readable()) {  
        chr = esp.getc();  
        pc.putc(chr);
        buffer[buffer_head++] = chr;  
        if (buffer_head == BUFFER_SIZE) 
        {  
            buffer_head = 0;  
        }  
    }  
}
void flush_fifo(void) 
{  
    while (esp.readable()) 
    {  
        (void)esp.getc();  
    }  
    buffer_head = 0;  
    buffer_tail = 0;  
}  
int find_response(const char *resp) {  
    /* Give some delay for buffer to fill up */  
    wait_ms(10);  
    int timeout = 0xFFFFFF;  
    int len = strlen(resp);  
    do 
    {  
        if (buffer_head > (buffer_tail + len)) 
        {  
            if (!memcmp(&buffer[buffer_tail], resp, len)) 
            {  
                flush_fifo();  
                return 0;  
            }  
            buffer_tail++;  
        }  
    }while(timeout--);  
    flush_fifo();  
    return 1;  
}

int main() 
{
    lcd.setMode(TextLCD::DispOn);
    lcd.setBacklight(TextLCD::LightOff);
    lcd.setCursor(TextLCD::CurOff_BlkOff);
    esp.attach(&rxcallback, Serial::RxIrq);
    lcd.setAddress(0,0);
    lcd.printf("Initial GPS...\n");
    esp.printf("AT+RST\r\n");
    //lcd.printf("1\n");
    MBED_ASSERT(find_response("OK") == 0);
    //lcd.printf("2\n");
    esp.printf("AT+CWMODE=1\r\n");
    //MBED_ASSERT(find_response("OK") == 0);
    //lcd.printf("3\n");
    esp.printf("AT+CWJAP=\"%s\",\"%s\"\r\n","Fookies-One(m8)","12312344");
    wait(5);
    //MBED_ASSERT(find_response("OK") == 0); 
    //lcd.printf("4\n");
    esp.printf("AT+CIPMUX=0\r\n");
    //MBED_ASSERT(find_response("OK") == 0); 
    //lcd.printf("5\n");
    while(1){
        if(gps.sample())
        {
            lcd.cls();
            lcd.printf("LAT:%6.3f\nLON:%7.3f",gps.latitude,gps.longitude);
        }
        wait(0.5);
        if(bt==0)
        {
            lcd.cls();
            lcd.printf("Sending to twitter");
            
            sprintf(s1,"api_key=GRMKGK1CTUU7L5RD&status=LAT:%.3f,LON:%.3f",gps.latitude,gps.longitude);
            sprintf(message,"POST /apps/thingtweet/1/statuses/update HTTP/1.1\nHost: api.thingspeak.com\nConnection: close\nContent-Type: application/x-www-form-urlencoded\nContent-Length: %d\n\n%s",strlen(s1),s1);
            esp.printf("AT+CIPSTART=\"TCP\",\"%s\",%s\r\n","184.106.153.149","80");
                //lcd.cls();
                //lcd.printf("AT+CIPSTART=\"TCP\",\"%s\",%s\r\n","184.106.153.149","80");
            wait(2);
            esp.printf("AT+CIPSEND=%d\r\n",strlen(message));
                //lcd.cls();
                //lcd.printf("AT+CIPSEND=%d\r\n",strlen(message));
                wait(2);
            if(find_response(">") == 0) 
            {
                //lcd.cls();
                //lcd.printf(message);
                esp.printf(message);
            }
            wait(2);  
            flush_fifo();
            esp.printf("AT+CIPCLOSE\r\n");
            wait(0.5);  
            flush_fifo();
            lcd.cls();
            lcd.printf("Send Completed\n");
        }
    }
}    
            