#include "mbed.h"
#include "hd44780_8bit.h" 
#include "ds1307.h"

Serial pc(USBTX, USBRX);
Serial toWifly(p13, p14);  // tx, rx
DS1307 my1307(p28,p27); // start DS1307 class and give it pins for connections of the DS1307 device
LocalFileSystem local("local"); // Create the local filesystem

 int sec = 0;
 int min = 0;
 int hours = 0;
 int day = 1; //sunday
 int date = 1;
 int month = 1;
 int year = 12; //2012
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalIn top(p20);
DigitalIn aup(p18);
DigitalIn bdw(p17);
DigitalIn bot(p19);

InterruptIn dbtrig(p24);
int trigState = 0;

//pushbuttons
InterruptIn menuButton(p25);
int menuState = 0;

DigitalIn menuUp(p26);
DigitalIn menuDown(p29);

//motor control pins
DigitalOut mena(p21);
DigitalOut mdown(p22);
DigitalOut mup(p23);

 void test_rw(int test) {
     if (test == 0) pc.printf("Last R/W operaion passed!\n\r");
     else pc.printf("Last R/W operation failed!\n\r");
 }
 
void up(void){
    mup=1;
    mdown=0;
}

void down(void) {
    mup=0;
    mdown=1;
}

void stop(void) {
    mup=0;
    mdown=0;
}

void gotoTop(void) {
    if(top) up();
    while(top) {
        led1=1;
    }
    stop();
    led1=0;
}

void gotoAup(void) {
    if(aup) up();
    while(aup) {
        led2=1;
    }
    stop();
    led2=0;
}

void gotoBot(void) {
    if(bot) down();
    while(bot) {
        led3=1;
    }
    stop();
    
    //give the ball time to enter lift
    wait(0.5); 
    led3=0;
}

//doorbell trigger interrupt routine
void doorbell() {
    //a little debouncing
    wait(0.01);
    if(dbtrig) trigState = 1;
}//doorbell

//menu setup trigger interrupt routine
void menuSetup() {
    wait(0.06);
    if(menuButton) menuState = 1;
}//menuSetup

int main() {        
    //LCD init
    BusOut *data=new BusOut(p7,p8,p9,p10,p11,p12,p15,p16);
    HD44780LCD8bit* lcd=new HD44780LCD8bit(16,2,data, p6, p5);
    lcd->init();
    lcd->writeText(0,0,"Alustetaan..");
    
    // set some default time to these values on the ds1307 connected device
    // test_rw(my1307.settime( sec, min, hours, day, date, month, year));
    
    wait(1);
        
    //sensor switches pull down the mbed pins when triggered   
    top.mode(PullUp);
    aup.mode(PullUp);
    bdw.mode(PullUp);
    bot.mode(PullUp);
    
    //pushbuttons also pull down the mbed pins
    menuButton.mode(PullUp);
    menuUp.mode(PullUp);
    menuDown.mode(PullUp);
    
    mena = 1;  //enable the L293D
    mdown = 0;
    mup = 0;
    
    //do a test run at start to find out where lift is now
    lcd->writeText(0,0,"Menossa alas");
    gotoBot();
    
    lcd->clear();
    wait(0.1);
    lcd->writeText(0,0,"Menossa");
    wait(0.1);
    lcd->writeText(0,1,"valmiustilaan"); 
    gotoAup();
    
    //setup doorbell interrupt and menu button interrupt
    dbtrig.rise(&doorbell);
    menuButton.fall(&menuSetup);
    
    //main loop
    while(1) {
    
      // DISPLAY CURRENT TIME AND DATE /////////////////////
    
      if(trigState==0 && menuState==0){
        lcd->clear();
        wait(0.1);
        
        //read time from ds1307
        test_rw(my1307.gettime( &sec, &min, &hours, &day, &date, &month, &year));
        lcd->locate(0,0);
        if (day == 1)
            lcd->printf("Su");
        if (day == 2)
            lcd->printf("Ma");   
        if (day == 3)
            lcd->printf("Ti");
        if (day == 4)
            lcd->printf("Ke");
        if (day == 5)
            lcd->printf("To");
        if (day == 6)
            lcd->printf("Pe");
        if (day == 7)
            lcd->printf("La");
            
        lcd->printf("  %.2D",date);
        lcd->printf(".%.2D",month);
        lcd->printf(".20%.2D",year);
        
        lcd->locate(0,1);    
        lcd->printf("Klo %.2D",hours);
        lcd->printf(":%.2D",min);
        //lcd->printf(":%.2D",sec);
        
        //'nonblocking' wait 5 sec
        for(int i=0;i<50;i++) {
            if(trigState==0 && menuState==0) {
                wait(0.1);
            }//if
            else {
                //break out of loop is doorbell
                //is triggered
                break;
            }//else
        }//for
      }//if trigState=0
      
      // DISPLAY LAST DOORBELL PRESS FROM LOG FILE /////////////////
      
      if(trigState==0 && menuState==0) {
       
        //read locally stored log file
        led1=led2=1;
        
        char buf[16]; //read 16 chars
        
        FILE *fp = fopen( "/local/doorbell.txt", "r");
        
        if(fp!=NULL) {           
            fgets(buf, sizeof(buf)+1, fp);
            fclose(fp);
        }//if not fp
        
        led1=led2=0;
      
        //print last doorbell ring on lcd
        lcd->clear();
        wait(0.1);
        lcd->locate(0,0);
        lcd->printf("Edellinen soitto");
        lcd->locate(0,1);
        lcd->printf("%s", buf);
        
        //'nonblocking' wait 5 sec
        for(int i=0;i<50;i++) {
            if(trigState==0 && menuState==0) {
                wait(0.1);
            }//if
            else {
                //break out of loop is doorbell
                //is triggered
                break;
            }//else
        }//for
      }//if trigState=0
      
      //DOORBELL IS PRESSED////////////////////////////
      if(trigState==1) {
        lcd->clear();
        wait(0.1);
        lcd->writeText(0,0,"Ovikello soi!");
        
        //log last doorbell press to local filesystem
        test_rw(my1307.gettime( &sec, &min, &hours, &day, &date, &month, &year));
        
        led1=led2=1;
        FILE *fp = fopen("/local/doorbell.txt", "w");
        
        //16 chars example
        //1234567890123456
        //Edellinen soitto
        //Ma 10.10.  10:10
        if (day == 1)
            fprintf(fp, "Su");
        if (day == 2)
            fprintf(fp, "Ma");   
        if (day == 3)
            fprintf(fp, "Ti");
        if (day == 4)
            fprintf(fp, "Ke");
        if (day == 5)
            fprintf(fp, "To");
        if (day == 6)
            fprintf(fp, "Pe");
        if (day == 7)
            fprintf(fp, "La");
            
        fprintf(fp, " %.2D",date);
        fprintf(fp, ".%.2D",month);
        fprintf(fp, ".  %.2D",hours);
        fprintf(fp, ":%.2D",min);
        fclose(fp); 
        led1=led2=0;
        
        //Write doorbell message to wifly serial.
        //t-codes:
        //1: critical
        //2: error/warning
        //3: info
        toWifly.printf("Ovikello&t=3");
        
        //run the lift
        gotoTop(); //launch ball
        
        //wait maximum 20 seconds 
        //(in case bdw sensor fails)
        int i=0;
        
        //wait for ball to get down
        while(bdw) {
            i++;
            led4 = !led4;
            wait(0.05);
            //100x 0.05 sec = 5 sec
            //need to count to 400 before break
            
            //break out of while after 20 seconds
            if(i>400) {
                lcd->clear();     //1234567890123456
                lcd->writeText(0,0,"Palloa ei kuulu,");
                wait(0.1);
                lcd->writeText(0,1,"haetaan se silti");
                wait(3);
                break;
            }//if
        }//while bdw
        led4=0;
        
        lcd->clear();
        lcd->writeText(0,0,"Menossa alas");
        gotoBot();
    
        lcd->clear();
        wait(0.1);
        lcd->writeText(0,0,"Menossa");
        wait(0.1);
        lcd->writeText(0,1,"valmiustilaan"); 
        gotoAup();
       
        //reset interrupt state        
        trigState=0;       
      }//if doorbell
      
      //if menu button is pressed
      if(menuState==1) {
        //reset menu state
        menuState = 0;
      
        //read time from ds1307
        test_rw(my1307.gettime( &sec, &min, &hours, &day, &date, &month, &year));
        
        //SET HOURS///////////////////////////////////
      
        lcd->clear();
        wait(0.1);
        lcd->writeText(0,0,"Aseta tunti");
        wait(0.1);
        
        //print current hour on second row
        lcd->locate(0,1);
        lcd->printf("%.2D",hours);
        
        //loop until menu state button is pressed again
        while(menuButton) {
            //if menu up button is pressed
            if(!menuUp) {
                wait(0.07); //debounce
                    if(!menuUp) {
                        hours++;
                        if(hours>23) hours=0;
                        lcd->locate(0,1);
                        lcd->printf("%.2D",hours);
                    }//inner if
            }//if menuup
            
            //if menu down button is pressed
            if(!menuDown) {
                wait(0.07); //debounce
                    if(!menuDown) {
                        hours--;
                        if(hours<0) hours=23;
                        lcd->locate(0,1);
                        lcd->printf("%.2D",hours);
                    }//inner if
            }//if menuup
          }//while not menustate hours
            
        //SET MINUTES/////////////////////////////////////
        
        lcd->clear();
        wait(0.1);
        lcd->writeText(0,0,"Aseta minuutti");
        wait(0.1);
        
        //print current min on second row
        lcd->locate(0,1);
        lcd->printf("%.2D",min);
        
        //loop until menu state button is pressed again
        while(menuButton) {
            //if menu up button is pressed
            if(!menuUp) {
                wait(0.07); //debounce
                    if(!menuUp) {
                        min++;
                        if(min>59) min=0;
                        lcd->locate(0,1);
                        lcd->printf("%.2D",min);
                    }//inner if
            }//if menuup
            
            //if menu down button is pressed
            if(!menuDown) {
                wait(0.07); //debounce
                    if(!menuDown) {
                        min--;
                        if(min<0) min=59;
                        lcd->locate(0,1);
                        lcd->printf("%.2D",min);
                    }//inner if
            }//if menuup
        }//while not menustate min
            
        //SET SECONDS/////////////////////////////////
         
        lcd->clear();
        wait(0.1);
        lcd->writeText(0,0,"Aseta sekunti");
        wait(0.1);
        
        //print current sec on second row
        lcd->locate(0,1);
        lcd->printf("%.2D",sec);
        
        //loop until menu state button is pressed again
        while(menuButton) {
            //if menu up button is pressed
            if(!menuUp) {
                wait(0.07); //debounce
                    if(!menuUp) {
                        sec++;
                        if(sec>59) sec=0;
                        lcd->locate(0,1);
                        lcd->printf("%.2D",sec);
                    }//inner if
            }//if menuup
            
            //if menu down button is pressed
            if(!menuDown) {
                wait(0.07); //debounce
                    if(!menuDown) {
                        sec--;
                        if(sec<0) sec=59;
                        lcd->locate(0,1);
                        lcd->printf("%.2D",sec);
                    }//inner if
            }//if menuup
        }//while not menustate sec 
        
        //SET WEEKDAY/////////////////////////////////
         
        lcd->clear();
        wait(0.1);
        lcd->writeText(0,0,"Aseta viikonpv");
        wait(0.1);
        
        //print current weekday on second row
        lcd->locate(0,1);

        if (day == 1)
            lcd->printf("Su");
        if (day == 2)
            lcd->printf("Ma");   
        if (day == 3)
            lcd->printf("Ti");
        if (day == 4)
            lcd->printf("Ke");
        if (day == 5)
            lcd->printf("To");
        if (day == 6)
            lcd->printf("Pe");
        if (day == 7)
            lcd->printf("La");
        
        //loop until menu state button is pressed again
        while(menuButton) {
            //if menu up button is pressed
            if(!menuUp) {
                wait(0.07); //debounce
                    if(!menuUp) {
                        day++;
                        if(day>7) day=1;
                        lcd->locate(0,1);
                        if (day == 1)
                            lcd->printf("Su");
                        if (day == 2)
                            lcd->printf("Ma");   
                        if (day == 3)
                            lcd->printf("Ti");
                        if (day == 4)
                            lcd->printf("Ke");
                        if (day == 5)
                            lcd->printf("To");
                        if (day == 6)
                            lcd->printf("Pe");
                        if (day == 7)
                            lcd->printf("La");
                    }//inner if
            }//if menuup
            
            //if menu down button is pressed
            if(!menuDown) {
                wait(0.07); //debounce
                    if(!menuDown) {
                        day--;
                        if(day<1) day=7;
                        lcd->locate(0,1);
                        if (day == 1)
                            lcd->printf("Su");
                        if (day == 2)
                            lcd->printf("Ma");   
                        if (day == 3)
                            lcd->printf("Ti");
                        if (day == 4)
                            lcd->printf("Ke");
                        if (day == 5)
                            lcd->printf("To");
                        if (day == 6)
                            lcd->printf("Pe");
                        if (day == 7)
                            lcd->printf("La");
                    }//inner if
            }//if menuup
        }//while not menustate weekday
        
        //SET DATE/////////////////////////////////
         
        lcd->clear();
        wait(0.1);
        lcd->writeText(0,0,"Aseta pvm");
        wait(0.1);
        
        //print current date on second row
        lcd->locate(0,1);
        lcd->printf("%.2D",date);
        
        //loop until menu state button is pressed again
        while(menuButton) {
            //if menu up button is pressed
            if(!menuUp) {
                wait(0.07); //debounce
                    if(!menuUp) {
                        date++;
                        if(date>31) date=1;
                        lcd->locate(0,1);
                        lcd->printf("%.2D",date);
                    }//inner if
            }//if menuup
            
            //if menu down button is pressed
            if(!menuDown) {
                wait(0.07); //debounce
                    if(!menuDown) {
                        date--;
                        if(date<1) date=31;
                        lcd->locate(0,1);
                        lcd->printf("%.2D",date);
                    }//inner if
            }//if menuup
        }//while not menustate date
        
        //SET MONTH/////////////////////////////////
         
        lcd->clear();
        wait(0.1);
        lcd->writeText(0,0,"Aseta kuukausi");
        wait(0.1);
        
        //print current sec on second row
        lcd->locate(0,1);
        lcd->printf("%.2D",month);
        
        //loop until menu state button is pressed again
        while(menuButton) {
            //if menu up button is pressed
            if(!menuUp) {
                wait(0.07); //debounce
                    if(!menuUp) {
                        month++;
                        if(month>12) month=1;
                        lcd->locate(0,1);
                        lcd->printf("%.2D",month);
                    }//inner if
            }//if menuup
            
            //if menu down button is pressed
            if(!menuDown) {
                wait(0.07); //debounce
                    if(!menuDown) {
                        month--;
                        if(month<1) month=12;
                        lcd->locate(0,1);
                        lcd->printf("%.2D",month);
                    }//inner if
            }//if menuup
        }//while not menustate month
        
        //SET YEAR/////////////////////////////////
         
        lcd->clear();
        wait(0.1);
        lcd->writeText(0,0,"Aseta vuosi");
        wait(0.1);
        
        //print current year on second row
        lcd->locate(0,1);
        lcd->printf("%.2D",year);
        
        //loop until menu state button is pressed again
        while(menuButton) {
            //if menu up button is pressed
            if(!menuUp) {
                wait(0.07); //debounce
                    if(!menuUp) {
                        year++;
                        if(sec>2100) year=2000;
                        lcd->locate(0,1);
                        lcd->printf("%.2D",year);
                    }//inner if
            }//if menuup
            
            //if menu down button is pressed
            if(!menuDown) {
                wait(0.07); //debounce
                    if(!menuDown) {
                        year--;
                        if(year<2000) year=2100;
                        lcd->locate(0,1);
                        lcd->printf("%.2D",year);
                    }//inner if
            }//if menuup
        }//while not menustate year
        
        //store new values in ds1307
        test_rw(my1307.settime( sec, min, hours, day, date, month, year));
        menuState = 0;
      }//if menustate
      
    }//while 1
}//main
