/*
* Cylon like sequencer for on board LEDs demo.
*
* Turns on LED and shifts it left to right and back again.
*
* Copyright (C) <2009> Tom Belpassso <tombelpasso@gmail.com>
*
* This is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* OneWire/DS18S20 is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* a copy of the GNU General Public License, see <http://www.gnu.org/licenses/>.
*/

#include "mbed.h"
// configuration equates
// time between shifting to next LED
#define SHIFT_TIME 0.04
// total time for sequence
#define REPEAT_TIME 1.0
// blank time between sequences
#define BLANK_TIME REPEAT_TIME - 9 * SHIFT_TIME

BusOut leds(LED1, LED2, LED3, LED4);

int main() {
    // i is used to turn on first LED in the sequence
    short i = 1;
    bool dir = 0 ; // 0 shift left, 1 shift right
    leds = 0;
    while(1) {
        if (dir)
            leds = (leds >> 1) + i;  // shift down
        else
            leds = (leds << 1) + i;    // shift 
        wait(SHIFT_TIME);
        if (leds != 0) {  // if any leds lit, don't turn any more on
            i = 0;
        }
        // see if all LEDs are off
        if (leds == 0) {
            // leds = 0 ;
            if (dir) {
                dir = 0 ;  // toggle directon
                i = 1;        // LSB LED on next shift
                wait(BLANK_TIME);
            } else {
                dir = 1;
                i = 8;        // MSB LED on next shift
                wait(SHIFT_TIME);
            }
        }
    }
}