/*
 Demo of Embedded Artists LPCXpresso baseboard SD card reader and audio facilities.

 By Tom Coxon

 Based on WAVEplayer by Vlad Cazan/Stephan Rochon modified by Tom Coxon to:

 1. Run correctly on the Embedded Artists LPCXpresso baseboard.
 2. To play 8 bit sample size in addition to original 16 bit
 3. To be more fault tolerant when playing wav files.

 Place suitable uncompressed wav files with 8 or 16 bit sample sizes on the SD card and ensure the
 file names are 8.3 format.  Then change the main method below to the relevant file paths.

 Please set all jumpers on board to the default case except for the following:

 Audio setup:

 1. Insert a jumper in J31 to connect signal PIO1_2 to the low
 pass filer as described in section 4.7.2. of base board users
 guide.

 2. Insert three jumpers in J33 to connect PIO3_0, PIO3_1 and
 PIO3_2 to control the amplifier as described in section 4.8
 of base board users guide.

 3. Insert a jumper in J32 and remove any from J34 to use the
 internal speaker as described in section 4.8
 of base board users guide.

 SD Card setup:

 4. Insert all five jumpers in J39 as described in section 4.3.3
 of base board users guide.

 5. Remove jumper marked "A" in J55 In order to connect PIO1_11
 to CS signal of J40 (the SPI-SSEL signal)  as described in section 4.3.3
 of base board users guide.
*/

#include "mbed.h"
#include "wavplayer.h"
#include "SDHCFileSystem.h"

DigitalOut led1(LED1);
DigitalOut led4(LED4);

SDFileSystem sd(p5, p6, p7, p24, "sd");

int main() {

    WavPlayer myWavPlayer;

    led1 = 1 ;
    printf("\r\n--------------- Starting -----------------\r\n");

    myWavPlayer.play_wave("/sd/startup.wav"); //  8 bit sample size

    myWavPlayer.play_wave("/sd/baddonut.wav");  // 16 bit sample size

    myWavPlayer.play_wave("/sd/dduck.wav");  // 8 bit sample size

    myWavPlayer.play_wave("/sd/bbunny.wav");  // 8 bit sample size

    printf("<<<<<<<<<<<<<<<< All done >>>>>>>>>>>>>>>>\r\n");
    led1 = 0;
    led4 = 1;
}
