#include "mbed.h"
#include "CAN.h"




bool Accept_Trame(CANMessage msg, char accept_code, char accept_mask)
{
   char id=msg.id>>3;int count=0, ref=0;
   for(int i=0;i<8;i++)
   {
        if(!((accept_mask>>i)&0x01))
        {
            ref++;
            if(((accept_code>>i)&0x01)==((id>>i)&0x01)) count++;
            else return false;
        }
   }
   if(count==ref) return true;
   else return false;
}

LocalFileSystem local("local");

Ticker ticker;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);


// CAN_RS pin at Philips PCA82C250 can bus controller.
// activate transceiver by pulling this pin to GND.
// (Rise and fall slope controlled by resistor R_s)
// (+5V result in tranceiver standby mode)
// For further information see datasheet page 4
//DigitalOut can_Pca82c250SlopePin(p28);

// second can controller on these pins. Not used here.
// CAN can1(p9, p10);

// We use can on mbed pins 29(CAN_TXD) and 30(CAN_RXD).
CAN can2(p30, p29);
Serial pc2(USBTX, USBRX);

FILE *fp ;

//#define pAF_MEM(i) (*(((volatile unsigned*) 0x40038000)+i));
unsigned int flag=0;
unsigned char donnees[8]={0,0,0,0,0,0,0,0}; 

void Init_reg()
{ 
//fill in the look up table RAM
 /*  *((volatile uint32_t *)(LPC_CANAF_RAM->mask+1))=0x43204320;
     *((volatile uint32_t *)(LPC_CANAF_RAM->mask+2))=0x45404540;*/
     //off mode on
     LPC_CANAF->AFMR = 0x00000001;
    // LPC_CAN2->MOD  |= 0x00000001;
     LPC_CANAF_RAM->mask[1]=0x43204540;
     LPC_CANAF_RAM->mask[2]=0x46104620;
     pc2.printf("@CANAF_RAM:%x\t donnees1:%x\t donnees2:%x\n",&(LPC_CANAF_RAM->mask[1]),LPC_CANAF_RAM->mask[1],LPC_CANAF_RAM->mask[2]);
//start of the first table, other tables are not used
   LPC_CANAF->SFF_sa     = 0x00000004;
   LPC_CANAF->SFF_GRP_sa = 0x0000000C;
   LPC_CANAF->EFF_sa     = 0x0000000C;
   LPC_CANAF->EFF_GRP_sa = 0x0000000C;
   LPC_CANAF->ENDofTable = 0x0000000C;
    pc2.printf("@SFF_SA:%x\t donnees:%x\n",&(LPC_CANAF->SFF_sa),LPC_CANAF->SFF_sa);
//operating mode  
    //LPC_CAN2->MOD  &= 0xFFFFFFFE;
    LPC_CANAF->AFMR = 0x00000000;
}
void Filter_msg()
{
//read present index 
    short index=(short)(LPC_CAN2->RFS&0x000001FF);
     pc2.printf("index: %x\n", index);
//get the identifier of the present trame 
    short id=(short)(LPC_CAN2->RID&0x000007FF);
    pc2.printf("ident: %x\n", id);
//get the length of the trame
    char DLC=(char)((LPC_CAN2->RFS&0x000F0000)>>16);
    //LPC_CANAF_RAM->mask[index/2];
   //short id_ref=(short)(LPC_CANAF_RAM->mask[index/2]&0x000007FF);
    //we can also use the function read
    //we retrieve the data and put them in an array of char
        if(DLC<=4)
        {
            for(int i=0;i<DLC;i++)
                donnees[i]=(char)((LPC_CAN2->RDA&(0x000000FF<<(8*i)))>>(8*i));
        }
        else
        {
            for(int i=0;i<4;i++)
                donnees[i]=(char)((LPC_CAN2->RDA&(0x000000FF<<(8*i)))>>(8*i));
            for (int k=0;k<DLC-4;k++)
                donnees[k+4]=(char)((LPC_CAN2->RDB&(0x000000FF<<(8*k)))>>(8*k));
        }
        //display data
        for(int i=0;i<DLC;i++)
        {
            pc2.printf("CanRx-->id:%x dlc:%d  donnee%d:%02x\t",id,DLC,i+1,donnees[i]);    
        }
         pc2.printf("\n");
        if(DLC==1)
        {
            led3=donnees[0]&0x01;
            led4=(donnees[0]&0x02)>>1;
        }
        led2=!led2;
        //we release the buffer reception
        LPC_CAN2->CMR=LPC_CAN2->CMR|0x00000004;
        pc2.printf("fin interrupt reception!\n");
}
void send() {
    static char counter = 0;
    CANMessage msg(0x200, &counter, 1);
    
    if (can2.write(msg)) {
      
       //  LPC_CAN2->CMR &= 0xEF; // stop back Tx
       pc2.printf("CanTx--> id: 0x200  dlc: 1  data: %x\n\r", counter);
        counter++;
    }
    // toggle led1 after every transmission
    led1 = !led1;
}
int main() {
    // 500kbit/s
    can2.frequency(500000);
    // every 500ms
    //ticker.attach(&send, 0.5);
    /// create message object for message reception 
    CANMessage can_MsgRx;
    //ligne serie
    pc2.baud(9600);
    pc2.format(8,Serial::None,1);
    pc2.printf("hello!\n");
    can2.attach(&Filter_msg);
    //configuration des registres
    Init_reg();
     while (1) {
    /*led4=!led4;
    wait(4);
    led4=!led4;*/
     /*if((LPC_CANAF->LUTerr&=0x00000001)==1)
     {
        pc2.printf("erreur dans la table\t");
        pc2.printf("adresse erreur:%x\n",LPC_CANAF->LUTerrAd&0x000007FC);
     }
        pc2.printf("test!");*/
       
       
        // send received messages to the pc via serial line (9k6, 8n1)
       /* if (can2.read(can_MsgRx)) {
               
                led3= can_MsgRx.data[0]&0x01;
                led4= (can_MsgRx.data[0]&0x02)>>1;
                // any incoming message: toggle led2
                pc2.printf("Receive  %3x  %2u\n\r",can_MsgRx.id,can_MsgRx.len);  
                led2 = !led2;
           
        }
        else {led4=!led4; wait(2);led4=!led4;}*/
    }
}