#include "mbed.h"
#include "C12832.h"
#include "DHT.h"


C12832 lcd(p5, p7, p6, p8, p11);    //LCD screen
DHT sensor(p16,DHT11); // Use the SEN11301P sensor
DigitalOut fan(p18);

int main()
{

//welcome message on LCD

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Hello user");
    lcd.locate(0,10);
    lcd.printf("Greenhouse Control System");
    wait(2.5);

    lcd.cls();      //clear LCD

    //infinte loop to check temperature after welcome message


    int error = 0;
    float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;
    lcd.cls();
    char tmpString[16];
    int temp_format = 0;
    int humid_format = 0;

    while(1) {

        wait(2.0f);
        error = sensor.readData();
        if (0 == error) {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            dpf = sensor.CalcdewPointFast(c, h);
            printf("Temperature in Kelvin: %4.2f, Celcius: %4.2f, Farenheit %4.2f\n", k, c, f);
            printf("Humidity is %4.2f, Dewpoint: %4.2f, Dewpoint fast: %4.2f\n", h, dp, dpf);
            printf("Tempformat: %d HumidFormat: %d\n", temp_format, humid_format);
            switch(temp_format) {
                case 0 :
                    sprintf(tmpString, " Temp: %4.2fC", c);
                    break;
                case 1 :
                    sprintf(tmpString, " Temp: %4.2fF", f);
                    break;
                case 2 :
                    sprintf(tmpString, " Temp: %4.2fK", k);
                    break;
            }

            //display the results onto the LCD
            lcd.locate(0,0);
            lcd.printf("Temperature: %4.2fC", c);
            lcd.locate(0,10);
            lcd.printf("Humidity: %4.2f", h);
            wait(2);

            //turn fan on if temperature is above 26
            if(c > 26) fan=1;   //fan is on
            else fan=0;         //Fan is off


            //wait 2 seconds and check temp again
            wait(2);
        }
    }
}
