#include "mbed.h"
#include "Servo.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);            //LCD screen
AnalogIn soil_moisture(p20);                //soil moisture sensor
Servo myservo(p21);                         //servo

int main()
{


    /*lcd.printf("Servo Calibration Controls:\n");
    lcd.printf("1,2,3 - Position Servo (full left, middle, full right)\n");
    lcd.printf("4,5 - Decrease or Increase range\n");*/

    float range = 0.0005;
    float position = 0.5;

    float moisture_value = 0.0f;


    while(1) {

        moisture_value = soil_moisture;                                               //soil moisture value
        lcd.locate(0,0);                                                               //text location on screen
        lcd.cls();
        lcd.printf("Moisture reading is: %2.2f\n", moisture_value);                     //display soil moisture value as a percentage
        wait(1.0f);
        //  lcd.printf("Moisture reading is: %2.2f\n", value);

        if (moisture_value > 30&& moisture_value <= 65) {                                 //if soil moisture level is between 30 and 60 moisture level okay
            lcd.printf("Moisture level okay");
            position = 0.0;
        }

        else if (moisture_value <= 30) {                                        //if soil moisture level is below 30, soil is dry
            position = 1.0;                                             //move servo to open position to water plant


        } else {
            position = 0.0;                                             //if soil moisture is above 65 soil is wet, do not water
        }



        lcd.printf("position = %.1f, range = +/-%0.4f\n", position, range);
        myservo.calibrate(range, 45.0);
        myservo = position;
    }
}