#include "mbed.h"
#include "C12832.h"
#include "tank.h"
#include "HCSR04.h"
#include "DHT.h"
#include "Servo.h"


C12832 lcd(p5, p7, p6, p8, p11);        // LCD screen
PwmOut r (p23);                         // r = red LED
PwmOut g (p24);                         // g = green LED
HCSR04 sensor(p9, p20);                 // ultrasonic distance sensor
DHT sensorB(p16,DHT11);                 // DHT11 temp & humi sensor
DigitalOut fan(p18);                     //grove relay control DC fan
DigitalOut myled(p14);                  //assigning greenled as digital output pin14
AnalogIn ldr(p15);                      //assigning ldr as analog input p15
AnalogIn soil_moisture(p19);             //soil moisture sensor
Servo myservo(p21);                      //servo


int main()
{
    int error = 0;
    float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;
    lcd.cls();
    char tmpString[16];
    int temp_format = 0;
    int humid_format = 0;
    float ldrout = 0.0;
    float range = 0.0005;
    float position = 0.5;
    float moisture_value = 0;

    while(true) {

                lcd.cls();
                lcd.locate(25,5);
                lcd.printf("Tank Water Level");
                lcd.locate(2,15);
                lcd.printf("Greenhouse Control System");
                wait(2.5);

                lcd.cls();      //clear LCD
                Timer timer;
                {

                    sensor.setRanges(0, 500);       // water tank level 500mm
                    lcd.print_bm(bitmEmptyTank,80,0);     // print Empty Tank at location x=80, y=0
                    lcd.copy_to_lcd();


                    timer.reset();
                    timer.start();
                    sensor.startMeasurement();

                }
                lcd.locate(20,5);
                lcd.printf("Distance:");
                lcd.locate(20,17);
                lcd.printf ("%5.1f mm\r", sensor.getDistance_mm());
                timer.stop();
                wait_ms(500 - timer.read_ms()); // time the loop

                //turn RGB LED red if distance >400mm

                if( sensor.getDistance_mm()< 400) r= 1; //red light on
                else r = 0;

                if( sensor.getDistance_mm()> 400) g=1; //green light on
                else g=0;         //green light off


                if( sensor.getDistance_mm() < 40 )  lcd.print_bm(bitmTank,80,0); //full tank
                lcd.copy_to_lcd();
                if( sensor.getDistance_mm() > 80 )  lcd.print_bm(bitmNinetyTank,80,0); //90% full tank
                lcd.copy_to_lcd();
                if( sensor.getDistance_mm() > 120  )  lcd.print_bm(bitmEightyTank,80,0); //80% full tank
                lcd.copy_to_lcd();
                if( sensor.getDistance_mm() > 160 )  lcd.print_bm(bitmSeventyTank,80,0); //70% full tank
                lcd.copy_to_lcd();
                if( sensor.getDistance_mm() > 200 )  lcd.print_bm(bitmSixtyTank,80,0); //60% full tank
                lcd.copy_to_lcd();
                if( sensor.getDistance_mm() > 240 )  lcd.print_bm(bitmFiftyTank,80,0); //50% full tank
                lcd.copy_to_lcd();
                if( sensor.getDistance_mm() > 280 )  lcd.print_bm(bitmFourtyTank,80,0); //40% full tank
                lcd.copy_to_lcd();
                if( sensor.getDistance_mm() > 320 )  lcd.print_bm(bitmThirtyTank,80,0); //30% full tank
                lcd.copy_to_lcd();
                if( sensor.getDistance_mm() > 360 )  lcd.print_bm(bitmTwentyTank,80,0); //20% full tank
                lcd.copy_to_lcd();
                if( sensor.getDistance_mm() > 400 )  lcd.print_bm(bitmTenTank,80,0); //10% full tank
                lcd.copy_to_lcd();
                if( sensor.getDistance_mm() > 440 )  lcd.print_bm(bitmEmptyTank,80,0); //empty tank
                lcd.copy_to_lcd();
                wait (2.5f);


                lcd.cls();
                lcd.locate(15,5);
                lcd.printf("Temp & Humidi Level");
                lcd.locate(2,15);
                lcd.printf("Greenhouse Control System");
                wait(2.5);

                lcd.cls();      //clear LCD
        

        wait(0.5f);
        error = sensorB.readData();

        if (0 == error) {

            c   = sensorB.ReadTemperature(CELCIUS);
            f   = sensorB.ReadTemperature(FARENHEIT);
            k   = sensorB.ReadTemperature(KELVIN);
            h   = sensorB.ReadHumidity();
            dp  = sensorB.CalcdewPoint(c, h);
            dpf = sensorB.CalcdewPointFast(c, h);
        }
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("K: %4.2f, C: %4.2f, F %4.2f\n", k, c, f);
        lcd.locate(0,10);
        lcd.printf("H: %4.2f, D: %4.2f, DF: %4.2f\n", h, dp, dpf);
        lcd.locate(0,20);
        lcd.printf("Tempf: %d HumidF: %d\n", temp_format, humid_format);
        
        //turn fan on if temperature is above 26
        if(c > 20) fan=1;   //fan is on
        else fan=0;         //Fan is off
        wait(2.5);
        //wait 2 seconds and check temp again


        //Light Sensor System

        lcd.cls();
        lcd.locate(25,5);
        lcd.printf("Light Level");
        lcd.locate(2,15);
        lcd.printf("Greenhouse Control System");
        wait(2.5);

        ldrout=ldr.read();                        //read ldr value

        lcd.cls();
        lcd.locate(10,10);
        lcd.printf("Light Level is: %f\n :",ldrout);       //print ldr value on LCD
        if(ldrout < 0.6) {                                //if ldr value is smaller than 0.6 green LED turns on

            myled = 1;                                  //LED on
        } else {
            myled=0;                                    //LED off
        }
        wait(2.5);

        //Soil Moisture System
        lcd.cls();
        lcd.locate(25,5);
        lcd.printf("Soil Moisture Level");
        lcd.locate(2,15);
        lcd.printf("Greenhouse Control System");
        wait(2.5);

        moisture_value = soil_moisture.read () *3.3;                                               //soil moisture value
       
        lcd.cls();
        lcd.locate(0,0);                                                               //text location on screen
        lcd.printf("Moisture reading is: %1.2f\n", moisture_value );                     //display soil moisture value as a percentage

        if (moisture_value < 1)  {                                 //if soil moisture level is between 30 and 60 moisture level okay
            lcd.locate(0,10);
            lcd.printf("Moisture level not okay");
            position = 0.0;
        }
        else {
            lcd.locate(0,10);
            lcd.printf("Moisture level is okay");
            position = 1.0;
        }  
        myservo.write(position);
        wait(2.5);
    }
}
