#include "mbed.h"

// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button 
//    is pressed
// The callback uses a shared variable to signal another thread

InterruptIn button(PTD0);
InterruptIn s_button(PTD2);
DigitalOut led(LED_BLUE);
DigitalOut s_led(LED_RED);
volatile int time1;
volatile int time2;

volatile int pressEvent = 0 ;
volatile int s_pressEvent = 0 ;

// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur 
void buttonCallback(){
    pressEvent = 1 ;   
}

void s_buttonCallback(){
    s_pressEvent = 1 ;
    
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    //S_led=1;
    button.mode(PullUp);             // Ensure button i/p has pull up
    button.fall(&buttonCallback) ;   // Attach function to falling edge
   
    //second button
    
    s_button.mode(PullUp);             
    s_button.fall(&s_buttonCallback) ;
    //s_led=1; 
    
    while(true) {
        // Toggle the LED every time the button is pressed
        
        // control button 1 (blue)
           
        if(time1==0){
            
        led=!led;
        }
        
        if(time2==0){
        s_led=!s_led;
        
        }
     
        //press event_1 coltrol button 1 (Blue)
        
        if (pressEvent) { 
           time1 = !time1;
            if(time1==1){    
            led = !led ;
            }
            pressEvent = 0 ; // Clear the event variable    
                 
        }
        
        //press even_2 coltrol button 2 (RED)
        if (s_pressEvent) {
            time2 = !time2;
            if(time2==1){
            s_led = !s_led ;
            }
            s_pressEvent = 0 ; // Clear the event variable    
             
        }
        Thread::wait(500) ;
    }
}