#include "mbed.h"
#include "rtos.h"
#include "wdt.h"

// Sample program using the Watchdog
// ---------------------------------
//    * Three threads co-operate to flash two LEDs
//    * A simple way to inject a fault, by pressing a button 
//    * The watchdog is configured with a 32ms timeout

#define ON 1
#define OFF 0
DigitalOut led_red(LED_RED, ON);
DigitalIn button(PTD0, PullUp);
DigitalOut led1(PTC12, OFF);
DigitalOut led2(PTC13, OFF);

// This ticker is used to feed the watch dog
Ticker tick;

// Threads
Thread threadT(osPriorityNormal, 1000); // timer thread 
Thread threadLED1(osPriorityNormal, 1000); // thread LED1
Thread threadLED2(osPriorityNormal, 1000); // thread LED2

// ------------Fault Injection Button-------------
//  Wait while the button is down
//     Use this to simulate a STUCK fault
// -----------------------------------------------
void waitButton() {
    while (!button) ;
}

// ---Thread for controlling LED 1----------------
//   Turn LED1 on/off in response to signals 
// -----------------------------------------------
void led1_thread() {  // method to run in thread
    osEvent evt ;
    while (true) {
        evt = Thread::signal_wait(0x0); // wait for any signal
        if (evt.status == osEventSignal) {
            if (evt.value.signals & 0x01) led1 = ON ;
            if (evt.value.signals & 0x02) led1 = OFF ;
            
            wdt_kickA();
        } 
        
    //waitButton() ;  // POSSIBLE FAULT HERE
    }
}

// ---Thread for controlling LED 2----------------
//   Turn LED2 on/off in response to signals 
// -----------------------------------------------
void led2_thread() {  // method to run in thread
    osEvent evt ;
    while (true) {
        evt = Thread::signal_wait(0x0); // wait for any signal
        if (evt.status == osEventSignal) {
            if (evt.value.signals & 0x01) led2 = ON ;
            if (evt.value.signals & 0x02) led2 = OFF ;
            
            wdt_kickB();
        } 
         //waitButton() ; // POSSIBLE FAULT HERE
    }
}

// ---Thread for timing --------------------------
//   Send signals to the other threads
// -----------------------------------------------
void timer_thread() {  // method to run in thread
    while (true) {
        Thread::wait(250) ;
        threadLED1.signal_set(0x1) ;
        threadLED2.signal_set(0x1) ;
        Thread::wait(250) ;
        threadLED1.signal_set(0x2) ;
        threadLED2.signal_set(0x2) ;
        
        
        waitButton() ; // POSSIBLE FAULT HERE
    }
}

// -----------MAIN-------------------------------
//    Configure watchdog. Start threads. 
//    Show start up with RED for 1sec
//    Remember the watchdog is running
//       - 1024ms to set it once
//       - then must feed it every 32ms  
// ----------------------------------------------

int main(void) {
    wdt_1sec() ; // initialise watchdog - 32ms timeout
    //tick.attach_us(callback(&wdt_kick_all), 20000); // ticks every 20ms    
    

    // start threads
    threadT.start(&timer_thread) ; // start the timer thread 
    threadLED1.start(&led1_thread) ; // start the LED1 control thread 
    threadLED2.start(&led2_thread) ; // start the LED2 control thread 
    
    // show start-up
    led_red = OFF;
    Thread::wait(1000) ;
    led_red = ON;
}