#include "mbed.h"
#include "TSISensor.h"

// Example program for lab 5
// -------------------------
//  A value is read from the touch sensor and use
//    to control two LEDs
//  The value is also output to the serial interface

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut redLED(LED_RED);
DigitalOut greenLED(LED_GREEN);
DigitalOut blueLED(LED_BLUE);
DigitalOut led1(D9);


TSISensor tsi;

Thread redThread  ; // thread for red LED
Thread greenThread  ; // thread for green LED
Thread blueThread; // thread for blue LED
Thread yellowThread ; // thread for yellow LED
Thread position; // thread position 
 
void red_thread() {  // method to run in thread
    while (true) {
        Thread::signal_wait(0x1);
        redLED = false ; // turn on 
        Thread::wait(5000);
        redLED = true ; // turn off 
        redThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}

void green_thread() {  // method to run in thread
    while (true) {
        Thread::signal_wait(0x1);
        greenLED = false ; // turn on 
        Thread::wait(5000);
        greenLED = true ; // turn off 
        greenThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}

// implement more thread 

// this is more thread 

void blue_thread() {  // method to run in thread
    while (true) {
        Thread::signal_wait(0x1);
        blueLED = false ; // turn on 
        Thread::wait(5000);
        blueLED = true ; // turn off 
        blueThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}

// this is for addititonal yellow 


void yellow_thread() {  // method to run in thread
    while (true) {
        Thread::signal_wait(0x1);
        led1 = false ; // turn on 
        Thread::wait(5000);
        led1 = true; // turn off 
        yellowThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}


int main(void) {
    redLED = true ; // turn off 
    greenLED = true ; // turn off 
    blueLED = true; // turn off
    led1 = true;  
    //yellowLED = true; // turn off 
    
    redThread.start(&red_thread) ; // start the red thread
    greenThread.start(&green_thread) ; // start the green thread
    blueThread.start(&blue_thread) ; // start the blue thread
    yellowThread.start(&yellow_thread) ; // start the green thread
    
    while (true) {
        uint8_t d = tsi.readDistance() ;  // Distance is between 0 and 39
                                          // When no touch --> 0
                                          // Left --> low value  Right --> high value
        pc.printf("%d \n \r", d) ;  
        pc.putc(' ') ;
        if (d > 3 && d < 9) {
            redThread.signal_set(0x1) ;
        }
        else if (d > 13 && d < 19) {
            greenThread.signal_set(0x1) ;
        }
        else if (d > 23 && d < 29) {
            blueThread.signal_set(0x1) ;
        }
        else if (d > 33 ) {
            yellowThread.signal_set(0x1) ;
        }
        else{
            
            
            
        }
        Thread::wait(50);  // This polling rate is too slow - increase it
                            // The slower rate maks it easier to output on the terminal
    }
}