#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"
 
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
 
#define MMA8451_I2C_ADDRESS (0x1d<<1)
 
int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);

    Serial pc(USBTX, USBRX); // tx, rx
 
    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());
 
    while (true) {
        float x, y, z;
         
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        
        //
        Thread::wait(300);
        
        // this is flat state
        if(z>= 0.9 ){ 
           
           
            rled = 0;
            gled = 0;
            bled =0;
            pc.printf("flat \n \r");
         //this is the left sate               
        }else if(y>= 0.9 ){
            
            rled = 0;
            gled = 0;
            bled =0;
            pc.printf("Left \n \r");
          //this is the down state  
        }else if(x>= 0.9){ 
            
            rled = 0;
            gled = 0;
            bled =0;
            pc.printf("down \n \r");
          //this is ver state  
        }else if(z<= -0.90 ){ 
            
            rled = 0;
            gled = 0;
            bled =0;
            pc.printf("over \n \r");
           //this is the right  
        }else if(y<= -0.90 ){ 
            
            rled = 0;
            gled = 0;
            bled =0;
            pc.printf("Right \n \r");
            //this is the Up
        }else if(x<= -0.90 ){
            
            rled = 0;
            gled = 0;
            bled =0;
            pc.printf("up \n \r");
            
        }
        // this is to turn the light off during the turn event 
        else{
            
            rled = 1;
            gled = 1;
            bled =1;
            pc.printf(" \n \r");
        }
        //print out the value 
        pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f \n \r", x, y, z);
    }
}

/*****************************************
Second part code please uncomment and turn above codes to comment to run 
#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"
 
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
  
  
  
  Timer timer;
 
#define MMA8451_I2C_ADDRESS (0x1d<<1)
 
int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);

    Serial pc(USBTX, USBRX); // tx, rx
 
    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());
 
    while (true) {
        float x, y, z;
         
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        
        // set the time
        
        timer.start();
        //timer.reset();
        
        
        
        //pc.printf("time is: %f \n \r",timer.read());
        Thread::wait(300);
        
       //check the time 
       
       
      
            
        // this is flat state
        if(timer.read() <=10 && z>= 0.9 ){  
           
           gled= 0;
           rled= 1;
           bled= 1;
           
           pc.printf("flat \n \r");
           
            pc.printf("time is: %f \n \r",timer.read());
           
          
                     
        }else if(timer.read()<=6 && y<= -0.90 ){ 
            
           gled= 0;
           rled= 1;
           bled= 1;
            
            pc.printf("Right \n \r");
            pc.printf("time is: %f \n \r",timer.read());
          
            
            //this is the Up
        }else if(timer.read()<=6 && x<= -0.90 ){
            
            gled= 0;
           rled= 1;
           bled= 1;
          
            pc.printf("up \n \r");
            pc.printf("time is: %f \n \r",timer.read());
            
           
        }
        
        else{
            
            pc.printf("Error message \n \r");
            rled = 0;
            timer.reset();
            gled= 1;
            rled= 0;
            bled= 1;
            
        }
            
       
        // this is to turn the light off during the turn event   
    
}
}


*******************************************/
