/* HTTPFile.h */
#ifndef HTTPFILE_H_
#define HTTPFILE_H_

#include "IHTTPData.h"
#include "FATFileSystem.h"
#include <string>

using std::string;

/** A data endpoint to store file
*/
class HTTPFile : public IHTTPDataIn, public IHTTPDataOut
{
public:
    /** Create an HTTPFile instance for input
     * @param path Path of file to store the incoming string
     */
    HTTPFile(const char* path);
    
    ~HTTPFile();
    
   /** Forces file closure
    */
    void clear();

protected:
    /** Read a piece of data to be transmitted
     * @param buf Pointer to the buffer on which to copy the data
     * @param len Length of the buffer
     * @param pReadLen Pointer to the variable on which the actual copied data length will be stored
     */
    virtual int read(char* buf, size_t len, size_t* pReadLen);
    
    /** Write a piece of data transmitted by the server
     * @param buf Pointer to the buffer from which to copy the data
     * @param len Length of the buffer
     */
    virtual int write(const char* buf, size_t len);
    
    /** Get MIME type
     * @param type Internet media type from Content-Type header
     */
    virtual int getDataType(char* type, size_t maxTypeLen); //Internet media type for Content-Type header
    
    /** Set MIME type
     * @param type Internet media type from Content-Type header
     */
    virtual void setDataType(const char* type);
    
    /** Determine whether the HTTP client should chunk the data
     *  Used for Transfer-Encoding header
     */
    virtual bool getIsChunked();
    
    /** Determine whether the data is chunked
     *  Recovered from Transfer-Encoding header
     */
    virtual void setIsChunked(bool chunked);
    
    /** If the data is not chunked, get its size
     *  Used for Content-Length header
     */
    virtual size_t getDataLen();
    
    /** If the data is not chunked, set its size
     * From Content-Length header
     */
    virtual void setDataLen(size_t len);
    
private:
    bool openFile(const char* mode); //true on success, false otherwise
    void closeFile();
    
    FILE* m_fp;
    string m_path;
    size_t m_len;
    bool m_chunked;
};

#endif /* HTTPFILE_H_ */
