/* BlinkLed.h */
#ifndef BLINKLED_H_
#define BLINKLED_H_

#include "mbed.h"
#include "rtos.h"

/** LED which blinks automatically with RTOS
*/
class BlinkLed
{
public:
    /** Constructor
     */
    BlinkLed(PinName pin, float dutyChangeStep, const char* name = NULL);
    
    /** Destructor
     */
    ~BlinkLed();
    
    /** Start biinking
     */
    void startBlink();
    
    /** Finish biinking
     */
    void finishBlink();
      
private:
    /** Copy constructor
     *  Disable because it is only declaration
     */
    BlinkLed(const BlinkLed&);
    
    /** Copy assignment operators
     *  Disable because it is only declaration
     */
    BlinkLed& operator=(const BlinkLed&);
    
    /** Function for blinking
     *  This function will be bind to new thread
     */
    static void blink(void const *argument);
    
    /** Target Led
     */
    PwmOut led;
    
    /** Duty ratio step of changing every 20ms
     */
    float dutyChangeStep;
    
    /** Pointer to thread for blinking
     */
    Thread* thread;
};


#endif /* BLINKLED_H_ */
