#include "BlinkLed.h"
    
BlinkLed::BlinkLed(PinName pin, float dutyChangeStep, const char* name) :
led(pin, name),
dutyChangeStep(dutyChangeStep),
thread(0)
{
}

BlinkLed::~BlinkLed()
{
}

void BlinkLed::startBlink()
{
    if(thread == 0)
    {
        thread = new Thread(blink, this, osPriorityNormal, 128, NULL);
    }
}

void BlinkLed::finishBlink()
{
    if(thread != 0)
    {
        thread->terminate();
        delete thread;
        thread = 0;
        led = 0.0;
    }
}

void BlinkLed::blink(void const *argument)
{
    BlinkLed* blinkLed = (BlinkLed*)argument;
    
    int up = 1;
    float brightness = 0.0;
    while (1) {
        if (up == 1 && brightness < 1.0) {
            ;
        } else if (up == 1 && brightness >= 1.0) {
            up = 0;
        } else if (up == 0 && brightness > 0) {
            ;
        } else if (up == 0 && brightness <= 0.0) {
            up = 1;
        } else {
            error("LED PWM error\n");
        }
        
        float dutyChangeStep = blinkLed->dutyChangeStep;
        if (up == 1) {
            brightness += dutyChangeStep;
        } else {
            brightness -= dutyChangeStep;
        }
        blinkLed->led = brightness;
        
        Thread::wait(20);
    }
}
