#ifndef RTC_8564_H
#define RTC_8564_H

#include "mbed.h"
#include "DebouncedEdgeIn/DebouncedEdgeIn.h"
#include "FunctionPointer.h"

class Rtc8564
{
public:
    Rtc8564(I2C& i2c, PinName clockIn, PinMode pull);
    
    void initialize();
    void setTime(struct tm* dateTime);
    void getTime(struct tm* dateTime);
    
    /** Attach a function to call at the timing of every second
     *
     *  @param fptr A pointer to a void function, or 0 to set as none
     */
    void clock(void (*fptr)(void));

    /** Attach a member function to call at the timing of every second
     *
     *  @param tptr pointer to the object to call the member function on
     *  @param mptr pointer to the member function to be called
     */
    template<typename T>
    void clock(T* tptr, void (T::*mptr)(void)) {
        m_clockFp.attach(tptr, mptr);
    }

private:
    bool checkVoltageLow();
    void clockRise();

    I2C& m_i2c;
    DebouncedEdgeIn m_clockIn;
    FunctionPointer m_clockFp;
};

#endif // RTC_8564_H
