#include "ClockViewModel.h"

using ViewModel::ClockViewModel;

// Icon Name ----
// Mark
// Battery_1
// Battery_2
// Battery_3
// Battery_4
// NoSound
// Lock
// ArrowDown
// ArrowUp
// Input
// Alarm
// Tell
// Antenna
// --------------

const char* ClockViewModel::WEEKDAYS[] = {"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT", "ERR"};

ClockViewModel::ClockViewModel(I2cLCD& i2clcd, PinName set, PinName increment, PinName decrement, PinName beep1, PinName beep2)
    :m_i2clcd(i2clcd),
     m_set(set),
     m_increment(increment),
     m_decrement(decrement),
     m_beep(beep1),
     m_beepGnd(beep2),
     m_clock(0),
     m_dateTime(0),
     m_mode(Model::CLOCK)
{
    m_set.mode(PullUp);
    m_increment.mode(PullUp);
    m_decrement.mode(PullUp);
    m_set.fall(this, &ClockViewModel::modeButtonOn);
    m_increment.fall(this, &ClockViewModel::incrementButtonOn);
    m_decrement.fall(this, &ClockViewModel::decrementButtonOn);
}

void ClockViewModel::setClock(Model::Clock* clock)
{
    m_clock = clock;
    m_dateTime = m_clock->getDateTime();
}

void ClockViewModel::initialize()
{
    // print ICON
    m_i2clcd.seticon( I2cLCD::Mark );
    m_i2clcd.seticon( I2cLCD::Battery_1 );
    m_i2clcd.seticon( I2cLCD::Battery_2 );
    m_i2clcd.seticon( I2cLCD::Battery_3 );
    m_i2clcd.seticon( I2cLCD::Battery_4 );
    m_i2clcd.seticon( I2cLCD::NoSound );
    m_i2clcd.seticon( I2cLCD::Lock );
    m_i2clcd.seticon( I2cLCD::ArrowDown );
    m_i2clcd.seticon( I2cLCD::ArrowUp );
    m_i2clcd.seticon( I2cLCD::Input );
    m_i2clcd.seticon( I2cLCD::Alarm );
    m_i2clcd.seticon( I2cLCD::Tell );
    m_i2clcd.seticon( I2cLCD::Antenna );
}

void ClockViewModel::dateTimeUpdated()
{
    static char dat[31] = " 20--/--/-- ***\n  -- : -- : --";
    uint8_t val = 0;

    val = m_dateTime->tm_year % 100;
    dat[3]  = '0' + val / 10;
    dat[4]  = '0' + val % 10;
    val = m_dateTime->tm_mon + 1;
    dat[6]  = '0' + val / 10;
    dat[7]  = '0' + val % 10;
    val = m_dateTime->tm_mday;
    dat[9]  = '0' + val / 10;
    dat[10] = '0' + val % 10;
    val = m_dateTime->tm_wday;
    dat[12] = WEEKDAYS[val][0];
    dat[13] = WEEKDAYS[val][1];
    dat[14] = WEEKDAYS[val][2];
    val = m_dateTime->tm_hour;
    dat[18] = '0' + val / 10;
    dat[19] = '0' + val % 10;
    val = m_dateTime->tm_min;
    dat[23] = '0' + val / 10;
    dat[24] = '0' + val % 10;
    val = m_dateTime->tm_sec;
    dat[28] = '0' + val / 10;
    dat[29] = '0' + val % 10;

    m_i2clcd.locate(0, 0);
    m_i2clcd.puts(dat);
    setCurSor();
}

void ClockViewModel::mode(Model::OperationMode mode)
{
    m_mode = mode;
    setCurSor();
}

void ClockViewModel::modeButtonOn()
{
    m_beep.beep(400, 0.05);
    m_clock->requestModeChange();
}

void ClockViewModel::incrementButtonOn()
{
    if(m_mode == Model::CLOCK) {
        return;
    }
    m_beep.beep(400, 0.05);
    m_clock->requestIncrementValue();
}

void ClockViewModel::decrementButtonOn()
{
    if(m_mode == Model::CLOCK) {
        return;
    }
    m_beep.beep(400, 0.05);
    m_clock->requestDecrementValue();
}

void ClockViewModel::setCurSor()
{
    switch(m_mode) {
        case Model::CLOCK:
            m_i2clcd.cursor(false, 0, 0);
            break;
        case Model::SET_YEAR:
            m_i2clcd.cursor(true, 4, 0);
            break;
        case Model::SET_MONTH:
            m_i2clcd.cursor(true, 7, 0);
            break;
        case Model::SET_DAY:
            m_i2clcd.cursor(true, 10, 0);
            break;
        case Model::SET_HOUR:
            m_i2clcd.cursor(true, 3, 1);
            break;
        case Model::SET_MINUTE:
            m_i2clcd.cursor(true, 8, 1);
            break;
        case Model::SET_SECOND:
            m_i2clcd.cursor(true, 13, 1);
            break;
        default:
            break;
    }
}
