#include "RtcMechanism.h"

RtcMechanism::RtcMechanism()
    :m_mode(Model::CLOCK),
     m_clock(0),
     m_dateTime(0),
     m_rtc(0)
{
}

void RtcMechanism::setClock(Model::Clock* clock)
{
    m_clock = clock;
    m_dateTime = m_clock->getDateTime();
}

void RtcMechanism::setRtc(Rtc8564* rtc)
{
    m_rtc = rtc;
    m_rtc->clock(this, &RtcMechanism::update);
}
  
void RtcMechanism::setPresentTime()
{
    m_rtc->setTime(m_dateTime);
}

void RtcMechanism::mode(Model::OperationMode mode)
{
    m_mode = mode;
}

void RtcMechanism::update()
{
    if(m_mode != Model::CLOCK) return;

    m_rtc->getTime(m_dateTime);

    m_clock->renew();
}
